/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.AUtilities;
import atlantis.utils.Plot;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;

public class APulseShapePlot {
    private static Vector frameVector = new Vector();

    private APulseShapePlot() {
    }

    public static void plotRealPulseShapes(int[][] adcCounts, double[][] realPulse, double step, String[] subTitle, String title) {
        JFrame frame = new JFrame(title);
        frame.setTitle(title);
        frame.setDefaultCloseOperation(2);
        AUtilities.setIconImage(frame);
        frame.setLocation(HTrackMomentaWindow.getGUI().getX(), HTrackMomentaWindow.getGUI().getY());
        Plot p = new Plot();
        frame.setContentPane(p);
        p.plotRealPulseShapes(adcCounts, realPulse, step, subTitle);
        frame.pack();
        int windowWidth = 330 + (adcCounts.length - 1) * 110;
        int windowHeight = 300;
        frame.setSize(windowWidth, windowHeight);
        frame.setVisible(true);
        frame.addWindowListener(new AllWindowsDisposer());
        frameVector.add(frame);
    }

    public static void plotRawCellPulseShapes(int[][] adcCounts, double[][] rawPulse, double[][] cellPulse, double step, String[] subTitle, String title) {
        JFrame frame = new JFrame(title);
        frame.setTitle(title);
        frame.setDefaultCloseOperation(2);
        AUtilities.setIconImage(frame);
        frame.setLocation(HTrackMomentaWindow.getGUI().getX(), HTrackMomentaWindow.getGUI().getY());
        Plot p = new Plot();
        frame.setContentPane(p);
        p.plotRawCellPulseShapes(adcCounts, rawPulse, cellPulse, step, subTitle);
        frame.pack();
        int windowWidth = 440 + (adcCounts.length - 1) * 140;
        int windowHeight = 400;
        frame.setSize(windowWidth, windowHeight);
        frame.setVisible(true);
        frame.addWindowListener(new AllWindowsDisposer());
        frameVector.add(frame);
    }

    public static void plotADCCounts(int[][] data, String title, String[] axis) {
        String[] newAxis;
        String[] labels = new String[data.length];
        String[] colors = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            labels[i] = "ADC counts";
            colors[i] = "blue";
        }
        if (axis != null) {
            newAxis = axis;
        } else {
            newAxis = new String[data.length];
            for (int i = 0; i < data.length; ++i) {
                newAxis[i] = "bunch crossing";
            }
        }
        APulseShapePlot.plotADCCounts(data, title, newAxis, labels, colors);
    }

    public static void plotADCCounts(int[][] data, String title, String[] axis, String[] labels, String[] colors) {
        JFrame frame = new JFrame(title);
        AUtilities.setIconImage(frame);
        frame.setLocation(HTrackMomentaWindow.getGUI().getX(), HTrackMomentaWindow.getGUI().getY());
        Plot p = new Plot();
        frame.setContentPane(p);
        p.plotADCCounts(data, axis, labels, colors);
        frame.pack();
        int windowWidth = 330 + (data.length - 1) * 110;
        int windowHeight = 300;
        frame.setSize(windowWidth, windowHeight);
        frame.setVisible(true);
        frame.addWindowListener(new AllWindowsDisposer());
        frameVector.add(frame);
    }

    static class AllWindowsDisposer
    extends WindowAdapter {
        AllWindowsDisposer() {
        }

        public void windowClosing(WindowEvent e) {
            for (int i = 0; i < frameVector.size(); ++i) {
                JFrame cf = (JFrame)frameVector.get(i);
                cf.dispose();
            }
            frameVector.removeAllElements();
        }
    }
}

