/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.Atlantis;
import atlantis.gui.AEventQueue;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.AAtlantisException;
import atlantis.utils.ALogger;
import atlantis.utils.SaveDialogFileFilter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AUtilities {
    private static ALogger logger = ALogger.getLogger(AUtilities.class);
    private static final String dateFormat = "yyyy-MM-dd-HH-mm-ss";

    private AUtilities() {
    }

    public static boolean isRightMouseButton(MouseEvent e) {
        return SwingUtilities.isRightMouseButton(e) || AEventQueue.getRightMouseButton();
    }

    public static boolean isIntRightMouseButton(MouseEvent e) {
        return SwingUtilities.isRightMouseButton(e) || AEventQueue.getIntRightMouseButton();
    }

    public static String getDateTimeString() {
        String r = null;
        Date d = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        r = sdf.format(d);
        return r;
    }

    private static void renameFile(String name, String title) throws Exception {
        String backupSuffix = "-backup_on_" + AUtilities.getDateTimeString();
        String dstName = name + backupSuffix;
        String errorMsg = "Renaming\n" + name + "\nto\n" + dstName + "\nfailed.";
        String msg = name + "\nexists and was successfully renamed to\n" + dstName;
        try {
            logger.debug("Renaming file " + name + " to " + dstName + " ...");
            File f = new File(name);
            if (!f.renameTo(new File(dstName))) {
                logger.error(errorMsg);
                throw new Exception(errorMsg);
            }
            logger.debug(msg);
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, title, 1);
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage(), ex);
            throw new Exception(errorMsg);
        }
    }

    public static String chooseFileAndWrite(Component component, String directory, String fileName, byte[] data, String title, String ext) throws AAtlantisException {
        String selectedDirectory = directory;
        if (directory == null) {
            directory = Atlantis.getHomeDirectory();
        }
        JFileChooser chooser = new JFileChooser(directory);
        chooser.setDialogTitle(title);
        chooser.setSelectedFile(new File(fileName));
        SaveDialogFileFilter filter = new SaveDialogFileFilter(ext);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(component);
        if (returnVal == 0) {
            String absPath = chooser.getSelectedFile().getAbsolutePath();
            File f = new File(absPath);
            if (f.exists()) {
                try {
                    AUtilities.renameFile(absPath, title);
                }
                catch (Exception ex) {
                    throw new AAtlantisException(ex.getMessage());
                }
            }
            try {
                BufferedOutputStream s = new BufferedOutputStream(new FileOutputStream(absPath));
                ((OutputStream)s).write(data);
                ((OutputStream)s).close();
                selectedDirectory = chooser.getSelectedFile().getParent();
            }
            catch (FileNotFoundException ex) {
                String msg = "Couldn't create the file.\nInsufficient permissions.";
                throw new AAtlantisException(msg);
            }
            catch (IOException ex) {
                String msg = "IO Error when writing the\ndata into the file.";
                throw new AAtlantisException(msg);
            }
        }
        return selectedDirectory;
    }

    public static void setIconImage(Frame f) {
        String path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "atlantis_icon.gif";
        ImageIcon ii = AUtilities.getFileAsImageIcon(path);
        f.setIconImage(ii.getImage());
    }

    private static String getLastDirectoryAndFileName(String fullPath) {
        int i;
        logger.debug("Trying to extract last directory and filename, input: " + fullPath);
        char[] charArray = fullPath.replaceAll("\\\\", "/").toCharArray();
        int sepOccurence = 0;
        for (i = fullPath.length() - 1; i > 0; --i) {
            if (charArray[i] == '/') {
                ++sepOccurence;
            }
            if (sepOccurence == 2) break;
        }
        String relPath = null;
        if (sepOccurence == 0) {
            logger.warn("No file separator found in the file path: " + fullPath);
            relPath = fullPath;
        } else if (i == 0) {
            logger.warn("The path looks like relative path already, using: " + fullPath);
            relPath = fullPath;
        } else {
            relPath = new String(charArray).substring(i + 1);
            logger.debug("Last directory and filename result: " + relPath);
        }
        return relPath;
    }

    public static InputStream getFileAsStream(String fileName) throws AAtlantisException {
        InputStream is = null;
        if (fileName == null || "".equals(fileName)) {
            String m = "Input parameter fileName is null or empty";
            logger.debug(m);
            throw new AAtlantisException(m);
        }
        try {
            logger.debug("Trying to access file: " + fileName + " ...");
            is = new FileInputStream(fileName);
            logger.debug("Reading " + fileName + " successful.");
        }
        catch (FileNotFoundException fnfe) {
            logger.warn(fileName + " not found, trying atlantis.jar ... ");
            String relPath = AUtilities.getLastDirectoryAndFileName(fileName);
            ClassLoader cl = AUtilities.class.getClassLoader();
            is = cl.getResourceAsStream(relPath);
            if (is == null) {
                String m = fileName + " doesn't exist, reading " + relPath + " from atlantis.jar failed.";
                logger.error(m);
                throw new AAtlantisException(m);
            }
            logger.debug(fileName + " reading from atlantis.jar successful.");
        }
        return is;
    }

    public static ImageIcon getFileAsImageIcon(String fileName) {
        ImageIcon ii = null;
        if (fileName == null || "".equals(fileName)) {
            String m = "Input parameter fileName is null or empty, can't get ImageIcon";
            logger.debug(m);
            return null;
        }
        File test = new File(fileName);
        if (test.exists() && test.canRead()) {
            ii = new ImageIcon(fileName);
            logger.debug("Reading " + fileName + " successful.");
        } else {
            logger.debug(fileName + " not found, trying atlantis.jar ... ");
            String relPath = AUtilities.getLastDirectoryAndFileName(fileName);
            ClassLoader cl = AUtilities.class.getClassLoader();
            ii = new ImageIcon(cl.getResource(relPath));
            if (ii == null) {
                String m = fileName + " doesn't exist, reading " + relPath + " from atlantis.jar failed";
                logger.debug(m);
            } else {
                logger.debug(fileName + " reading from atlantis.jar successful.");
            }
        }
        return ii;
    }
}

