/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import java.awt.geom.Point2D;

public class AVector {
    public double dx;
    public double dy;

    public AVector(double dx, double dy) {
        this.set(dx, dy);
    }

    public AVector(double x1, double y1, double x2, double y2) {
        this.set(x2 - x1, y2 - y1);
    }

    public AVector(Point2D p1, Point2D p2) {
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public AVector set(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
        return this;
    }

    public AVector getUnitary() {
        double r = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        return new AVector(this.dx / r, this.dy / r);
    }

    public AVector makeUnitary() {
        double r = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.dx /= r;
        this.dy /= r;
        return this;
    }

    public AVector rotate(double alpha) {
        double sin = Math.sin(alpha);
        double cos = Math.cos(alpha);
        double dx_prime = this.dx * cos - this.dy * sin;
        double dy_prime = this.dx * sin + this.dy * cos;
        this.dx = dx_prime;
        this.dy = dy_prime;
        return this;
    }

    public AVector scale(double factor) {
        this.dx *= factor;
        this.dy *= factor;
        return this;
    }

    public AVector invert() {
        this.dx *= -1.0;
        this.dy *= -1.0;
        return this;
    }

    public double modulus() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    public AVector add(AVector v) {
        this.dx += v.dx;
        this.dy += v.dy;
        return this;
    }

    public String toString() {
        return "AVector[dx=" + this.dx + ", dy=" + this.dy + "]";
    }
}

