/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IPlotter;
import hep.aida.IPlotterStyle;
import hep.aida.ITree;
import hep.aida.ref.plotter.PlotterUtilities;
import java.awt.BorderLayout;
import javax.swing.JPanel;

class Plot
extends JPanel {
    public Plot() {
        super(new BorderLayout());
    }

    protected void plotRealPulseShapes(int[][] adcCounts, double[][] realPulse, double step, String[] subTitle) {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IDataPointSetFactory dpsf = af.createDataPointSetFactory(tree);
        IDataPointSet[] dataPointSet = new IDataPointSet[adcCounts.length];
        for (int i = 0; i < adcCounts.length; ++i) {
            String myTitle = subTitle != null ? subTitle[i] : "Real pulse shape";
            double[] x = new double[adcCounts[i].length];
            double[] y = new double[adcCounts[i].length];
            double[] e = new double[adcCounts[i].length];
            for (int ii = 0; ii < adcCounts[i].length; ++ii) {
                x[ii] = (double)ii + 1.0;
                y[ii] = adcCounts[i][ii];
                e[ii] = 0.0;
            }
            dataPointSet[i] = dpsf.createXY(myTitle, x, y, e, e);
            dataPointSet[i].setTitle(myTitle);
        }
        IDataPointSet[] dataPointSetReal = new IDataPointSet[realPulse.length];
        for (int i = 0; i < realPulse.length; ++i) {
            String myTitle = subTitle != null ? subTitle[i] : "Real pulse shape";
            double[] x = new double[realPulse[i].length];
            double[] y = new double[realPulse[i].length];
            double[] e = new double[realPulse[i].length];
            double d = 1.0;
            for (int ii = 0; ii < realPulse[i].length; ++ii) {
                x[ii] = d;
                y[ii] = realPulse[i][ii];
                e[ii] = 0.0;
                d += step;
            }
            dataPointSetReal[i] = dpsf.createXY(myTitle, x, y, e, e);
            dataPointSetReal[i].setTitle(myTitle);
        }
        IPlotter plotter = af.createPlotterFactory().create("");
        plotter.createRegions(adcCounts.length, 1);
        IPlotterStyle style = af.createPlotterFactory().createPlotterStyle();
        style.xAxisStyle().setLabel("bunch crossing");
        style.yAxisStyle().setLabel("ADC counts");
        style.titleStyle().textStyle().setColor("black");
        style.titleStyle().textStyle().setBold(true);
        style.xAxisStyle().labelStyle().setColor("black");
        style.yAxisStyle().labelStyle().setColor("black");
        style.statisticsBoxStyle().setVisible(false);
        style.legendBoxStyle().setVisible(false);
        for (int i = 0; i < adcCounts.length; ++i) {
            style.dataStyle().markerStyle().setParameter("size", "2");
            style.dataStyle().markerStyle().setShape("box");
            plotter.region(i).style().dataStyle().markerStyle().setColor("red");
            plotter.region(i).plot(dataPointSetReal[i], style);
            style.dataStyle().markerStyle().setParameter("size", "7");
            style.dataStyle().markerStyle().setShape("dot");
            plotter.region(i).style().dataStyle().markerStyle().setColor("blue");
            plotter.region(i).plot(dataPointSet[i], style);
        }
        this.add(PlotterUtilities.componentForPlotter((IPlotter)plotter), "Center");
    }

    public void plotADCCounts(int[][] data, String[] axis, String[] labels, String[] colors) {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IDataPointSetFactory dpsf = af.createDataPointSetFactory(tree);
        IDataPointSet[] dataPointSet = new IDataPointSet[data.length];
        for (int j = 0; j < data.length; ++j) {
            dataPointSet[j] = dpsf.create("plot", labels[j], 2);
            for (int i = 0; i < data[j].length; ++i) {
                dataPointSet[j].addPoint();
                IDataPoint dp = dataPointSet[j].point(i);
                dp.coordinate(0).setValue((double)i);
                dp.coordinate(1).setValue((double)data[j][i]);
            }
        }
        IPlotter plotter = af.createPlotterFactory().create("");
        plotter.createRegions(data.length, 1);
        IPlotterStyle style = af.createPlotterFactory().createPlotterStyle();
        style.yAxisStyle().setLabel("ADC counts");
        style.dataStyle().markerStyle().setParameter("size", "7");
        style.dataStyle().markerStyle().setShape("dot");
        style.titleStyle().textStyle().setColor("black");
        style.titleStyle().textStyle().setBold(true);
        style.xAxisStyle().labelStyle().setColor("black");
        style.yAxisStyle().labelStyle().setColor("black");
        style.statisticsBoxStyle().setVisible(false);
        style.legendBoxStyle().setVisible(false);
        for (int j = 0; j < data.length; ++j) {
            plotter.region(j).style().xAxisStyle().setLabel(axis[j]);
            plotter.region(j).style().dataStyle().markerStyle().setColor(colors[j]);
            plotter.region(j).style().dataStyle().outlineStyle().setColor(colors[j]);
            plotter.region(j).plot(dataPointSet[j], style);
        }
        this.add(PlotterUtilities.componentForPlotter((IPlotter)plotter), "Center");
    }

    protected void plotRawCellPulseShapes(int[][] adcCounts, double[][] rawPulse, double[][] cellPulse, double step, String[] subTitle) {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IDataPointSetFactory dpsf = af.createDataPointSetFactory(tree);
        IDataPointSet[] dataPointSet = new IDataPointSet[adcCounts.length];
        for (int i = 0; i < adcCounts.length; ++i) {
            String myTitle = "ADC counts";
            double[] x = new double[adcCounts[i].length];
            double[] y = new double[adcCounts[i].length];
            double[] e = new double[adcCounts[i].length];
            for (int ii = 0; ii < adcCounts[i].length; ++ii) {
                x[ii] = (double)ii + 1.0;
                y[ii] = adcCounts[i][ii];
                e[ii] = 0.0;
            }
            dataPointSet[i] = dpsf.createXY(myTitle, x, y, e, e);
            dataPointSet[i].setTitle(myTitle);
        }
        IDataPointSet[] dataPointSetCell = new IDataPointSet[cellPulse.length];
        for (int i = 0; i < cellPulse.length; ++i) {
            String myTitle = "Cell time";
            double[] x = new double[cellPulse[i].length];
            double[] y = new double[cellPulse[i].length];
            double[] e = new double[cellPulse[i].length];
            double d = 1.0;
            for (int ii = 0; ii < cellPulse[i].length; ++ii) {
                x[ii] = d;
                y[ii] = cellPulse[i][ii];
                e[ii] = 0.0;
                d += step;
            }
            dataPointSetCell[i] = dpsf.createXY(myTitle, x, y, e, e);
            dataPointSetCell[i].setTitle(myTitle);
        }
        IDataPointSet[] dataPointSetRaw = new IDataPointSet[rawPulse.length];
        for (int i = 0; i < rawPulse.length; ++i) {
            String myTitle = "Raw time";
            double[] x = new double[rawPulse[i].length];
            double[] y = new double[rawPulse[i].length];
            double[] e = new double[rawPulse[i].length];
            double d = 1.0;
            for (int ii = 0; ii < rawPulse[i].length; ++ii) {
                x[ii] = d;
                y[ii] = rawPulse[i][ii];
                e[ii] = 0.0;
                d += step;
            }
            dataPointSetRaw[i] = dpsf.createXY(myTitle, x, y, e, e);
            dataPointSetRaw[i].setTitle(myTitle);
        }
        IPlotter plotter = af.createPlotterFactory().create("");
        plotter.createRegions(adcCounts.length, 1);
        IPlotterStyle style = af.createPlotterFactory().createPlotterStyle();
        style.xAxisStyle().setLabel("bunch crossing");
        style.yAxisStyle().setLabel("ADC counts");
        style.titleStyle().textStyle().setColor("black");
        style.titleStyle().textStyle().setBold(true);
        style.xAxisStyle().labelStyle().setColor("black");
        style.yAxisStyle().labelStyle().setColor("black");
        style.statisticsBoxStyle().setVisible(false);
        style.legendBoxStyle().setVisible(true);
        for (int i = 0; i < adcCounts.length; ++i) {
            style.dataStyle().markerStyle().setParameter("size", "4");
            style.dataStyle().markerStyle().setShape("box");
            style.dataStyle().showInLegendBox(true);
            plotter.region(i).style().dataStyle().markerStyle().setColor("red");
            plotter.region(i).plot(dataPointSetRaw[i], style);
            style.dataStyle().markerStyle().setParameter("size", "2");
            style.dataStyle().markerStyle().setShape("box");
            style.dataStyle().showInLegendBox(true);
            plotter.region(i).style().dataStyle().markerStyle().setColor("green");
            plotter.region(i).plot(dataPointSetCell[i], style);
            style.dataStyle().markerStyle().setParameter("size", "7");
            style.dataStyle().markerStyle().setShape("dot");
            style.dataStyle().showInLegendBox(false);
            plotter.region(i).style().dataStyle().markerStyle().setColor("blue");
            plotter.region(i).plot(dataPointSet[i], style);
            plotter.region(i).setTitle(subTitle != null ? subTitle[i] : "Real pulse shape");
        }
        this.add(PlotterUtilities.componentForPlotter((IPlotter)plotter), "Center");
    }
}

