/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import Jama.Matrix;
import atlantis.utils.AMath;

class Transformation {
    double rho;
    double tau;
    double phi0;
    double d0;
    double z0;
    double sinPhi;
    double cosPhi;
    double sinDPhi;
    double cosDPhi;
    double eta;
    double s;
    double r;
    double dPhi;

    Transformation(Matrix fitted, int iHelix) {
        int index = 3 + 3 * iHelix;
        this.eta = fitted.get(index++, 0);
        this.tau = fitted.get(index++, 0);
        this.phi0 = fitted.get(index++, 0);
        double sinPhi0 = Math.sin(this.phi0);
        double cosPhi0 = Math.cos(this.phi0);
        double xC = -this.eta * sinPhi0;
        double yC = this.eta * cosPhi0;
        double xVxC = fitted.get(0, 0) - xC;
        double yVyC = fitted.get(1, 0) - yC;
        this.r = 0.0;
        this.r = this.eta > 0.0 ? Math.sqrt(xVxC * xVxC + yVyC * yVyC) : -Math.sqrt(xVxC * xVxC + yVyC * yVyC);
        this.d0 = this.r - this.eta;
        this.sinPhi = xVxC / this.r;
        this.cosPhi = -yVyC / this.r;
        double phi = Math.atan2(this.sinPhi, this.cosPhi);
        if (phi - this.phi0 < -Math.PI) {
            phi += Math.PI * 2;
        }
        this.dPhi = phi - this.phi0;
        this.s = this.dPhi * this.r;
        this.z0 = fitted.get(2, 0) - this.s * this.tau;
        this.sinDPhi = Math.sin(this.dPhi);
        this.cosDPhi = Math.cos(this.dPhi);
        this.rho = 1.0 / this.r;
    }

    Matrix getHelixdMdF() {
        Matrix dMdF = new Matrix(5, 6);
        double curvature = AMath.getCurvature();
        dMdF.set(4, 0, -curvature * this.rho * this.rho * this.sinPhi);
        dMdF.set(4, 1, curvature * this.rho * this.rho * this.cosPhi);
        dMdF.set(4, 3, -curvature * this.rho * this.rho * this.cosDPhi);
        dMdF.set(4, 5, -curvature * this.rho * this.rho * this.eta * this.sinDPhi);
        dMdF.set(3, 4, 1.0);
        dMdF.set(2, 5, 1.0);
        dMdF.set(0, 0, this.sinPhi);
        dMdF.set(0, 1, -this.cosPhi);
        dMdF.set(0, 3, this.cosDPhi - 1.0);
        dMdF.set(0, 5, this.eta * this.sinDPhi);
        dMdF.set(1, 0, -this.tau * (this.sinPhi * this.dPhi + this.cosPhi));
        dMdF.set(1, 1, this.tau * (this.cosPhi * this.dPhi - this.sinPhi));
        dMdF.set(1, 2, 1.0);
        dMdF.set(1, 3, -this.tau * (this.dPhi * this.cosDPhi - this.sinDPhi));
        dMdF.set(1, 4, -this.s);
        dMdF.set(1, 5, -this.tau * (this.eta * (this.dPhi * this.sinDPhi + this.cosDPhi) - this.r));
        return dMdF;
    }

    Matrix helixFromFitted() {
        Matrix helix = new Matrix(5, 1);
        helix.set(4, 0, this.rho * AMath.getCurvature());
        helix.set(3, 0, this.tau);
        helix.set(2, 0, this.phi0);
        helix.set(0, 0, this.d0);
        helix.set(1, 0, this.z0);
        return helix;
    }
}

