/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils.xml;

import atlantis.utils.xml.AArrayParser;

public class AFloatArrayParser
extends AArrayParser {
    private static final int SKIPPING_BLANKS = 0;
    private static final int CHECKING_MINUS = 1;
    private static final int CHECKING_INF1 = 2;
    private static final int CHECKING_INF2 = 3;
    private static final int CHECKING_INF3 = 4;
    private static final int READING_INT = 5;
    private static final int CHECKING_DOT = 6;
    private static final int READING_FLOAT = 7;
    private static final int CHECKING_EXP = 8;
    private static final int CHECKING_EXP_SIGN = 9;
    private static final int READING_EXP = 10;
    private static final int FINISHING = 11;
    private static final int IGNORE = 12;
    private static double[] powers = new double[400];
    private float[] array;
    private float number = 0.0f;
    private int floatDigits = 0;
    private int exp = 0;
    private int expSign = 1;
    private boolean isInf = false;

    public AFloatArrayParser(int size) {
        this.array = new float[size];
        this.count = 0;
        this.state = size == 0 ? 12 : 0;
        this.sign = 1;
    }

    public void parse(char[] ch, int start, int length) {
        if (this.state == 12) {
            this.finished = true;
            return;
        }
        int end = start + length;
        block16: for (int i = start; i < end; ++i) {
            char c = ch[i];
            block17: while (true) {
                switch (this.state) {
                    case 0: {
                        if (c == ' ' || c == '\n') continue block16;
                        this.finished = false;
                        ++this.state;
                        continue block17;
                    }
                    case 1: {
                        if (c == '-') {
                            this.sign = -1;
                            ++this.state;
                            continue block16;
                        }
                        ++this.state;
                        continue block17;
                    }
                    case 2: {
                        if (c == 'i' || c == 'I') {
                            ++this.state;
                            continue block16;
                        }
                        this.state = 5;
                        continue block17;
                    }
                    case 3: {
                        if (c == 'n' || c == 'N') {
                            ++this.state;
                            continue block16;
                        }
                        this.state = 11;
                        continue block17;
                    }
                    case 4: {
                        if (c == 'f' || c == 'F') {
                            this.state = 11;
                            this.isInf = true;
                            continue block16;
                        }
                        this.state = 11;
                        continue block17;
                    }
                    case 5: {
                        if (c >= '0' && c <= '9') {
                            this.number = this.number * 10.0f + (float)c - 48.0f;
                            continue block16;
                        }
                        ++this.state;
                        continue block17;
                    }
                    case 6: {
                        if (c == '.') {
                            ++this.state;
                            continue block16;
                        }
                        ++this.state;
                        continue block17;
                    }
                    case 7: {
                        if (c >= '0' && c <= '9') {
                            this.number = this.number * 10.0f + (float)c - 48.0f;
                            ++this.floatDigits;
                            continue block16;
                        }
                        ++this.state;
                        continue block17;
                    }
                    case 8: {
                        if (c == 'e' || c == 'E') {
                            ++this.state;
                            continue block16;
                        }
                        this.state = 11;
                        continue block17;
                    }
                    case 9: {
                        if (c == '-') {
                            this.expSign = -1;
                            ++this.state;
                            continue block16;
                        }
                        if (c == '+') {
                            this.expSign = 1;
                            ++this.state;
                            continue block16;
                        }
                        ++this.state;
                        continue block17;
                    }
                    case 10: {
                        if (c >= '0' && c <= '9') {
                            this.exp = this.exp * 10 + c - 48;
                            continue block16;
                        }
                        ++this.state;
                        continue block17;
                    }
                    case 11: {
                        if (c == ' ' || c == '\n') {
                            try {
                                if (this.isInf) {
                                    this.array[this.count] = this.sign == 1 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
                                    this.isInf = false;
                                } else {
                                    this.array[this.count] = (float)((double)(this.number * (float)this.sign) * powers[this.expSign * this.exp - this.floatDigits + 200]);
                                }
                            }
                            catch (IndexOutOfBoundsException e) {
                                throw new IndexOutOfBoundsException("more");
                            }
                            this.state = 0;
                            this.sign = 1;
                            this.exp = 0;
                            this.expSign = 1;
                            this.floatDigits = 0;
                            this.number = 0.0f;
                            ++this.count;
                            this.finished = true;
                            continue block16;
                        }
                        throw new NumberFormatException("" + c);
                    }
                    default: {
                        continue block17;
                    }
                }
                break;
            }
        }
    }

    public Object getArray() {
        if (!this.finished) {
            this.array[this.count] = (float)((double)(this.number * (float)this.sign) * powers[this.expSign * this.exp - this.floatDigits + 200]);
        }
        return this.array;
    }

    static {
        for (int i = 0; i < 400; ++i) {
            AFloatArrayParser.powers[i] = Math.pow(10.0, i - 200);
        }
    }
}

