/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils.xml;

import atlantis.utils.xml.AArrayParser;

public class AIntArrayParser
extends AArrayParser {
    private static final int SKIPPING_BLANKS = 0;
    private static final int CHECKING_MINUS = 1;
    private static final int READING_INT = 2;
    private static final int FINISHING = 3;
    private static final int IGNORE = 4;
    private int[] array;
    private int number = 0;

    public AIntArrayParser(int size) {
        this.array = new int[size];
        this.count = 0;
        this.state = size == 0 ? 4 : 0;
        this.sign = 1;
    }

    public void parse(char[] ch, int start, int length) {
        if (this.state == 4) {
            this.finished = true;
            return;
        }
        int end = start + length;
        block8: for (int i = start; i < end; ++i) {
            char c = ch[i];
            block9: while (true) {
                switch (this.state) {
                    case 2: {
                        if (c >= '0' && c <= '9') {
                            this.number = this.number * 10 + c - 48;
                            continue block8;
                        }
                        ++this.state;
                        continue block9;
                    }
                    case 0: {
                        if (c == ' ' || c == '\n') continue block8;
                        this.finished = false;
                        ++this.state;
                        continue block9;
                    }
                    case 1: {
                        if (c == '-') {
                            this.sign = -1;
                            ++this.state;
                            continue block8;
                        }
                        ++this.state;
                        continue block9;
                    }
                    case 3: {
                        if (c == ' ' || c == '\n') {
                            try {
                                this.array[this.count] = this.number * this.sign;
                            }
                            catch (IndexOutOfBoundsException e) {
                                throw new IndexOutOfBoundsException("more");
                            }
                            this.number = 0;
                            ++this.count;
                            this.sign = 1;
                            this.state = 0;
                            this.finished = true;
                            continue block8;
                        }
                        throw new NumberFormatException("" + c);
                    }
                    default: {
                        continue block9;
                    }
                }
                break;
            }
        }
    }

    public Object getArray() {
        if (!this.finished) {
            this.array[this.count] = this.number * this.sign;
        }
        return this.array;
    }
}

