/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils.xml;

import atlantis.gui.AExceptionHandler;
import atlantis.utils.ALogger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class AXMLErrorHandler
implements ErrorHandler {
    private final ALogger logger = ALogger.getLogger(AXMLErrorHandler.class);
    private ErrorState errorState = ErrorState.NO_ERROR;
    private Throwable cause = null;

    public ErrorState getErrorState() {
        return this.errorState;
    }

    public Throwable getErrorCause() {
        return this.cause;
    }

    public void setError(ErrorState errorState, Throwable cause) {
        if (cause == null && errorState != ErrorState.NO_ERROR) {
            throw new IllegalArgumentException("Cause can not be NULL");
        }
        this.errorState = errorState;
        this.cause = errorState == ErrorState.NO_ERROR ? null : cause;
    }

    public void error(SAXParseException exception) {
        if (this.getErrorState() != ErrorState.NO_ERROR) {
            return;
        }
        String errorMessage = exception.getMessage();
        if (errorMessage.startsWith("Element type") && errorMessage.indexOf("must be declared") >= 0) {
            this.setError(ErrorState.UNKNOWN_TAG, exception);
            return;
        }
        if (errorMessage.startsWith("The content of element type") && errorMessage.indexOf("must match") >= 0) {
            this.setError(ErrorState.INVALID_DATA, exception);
            return;
        }
        this.logger.error("Parsing XML in line " + exception.getLineNumber() + ": " + errorMessage);
        this.setError(ErrorState.OTHER_ERROR, exception);
    }

    public void warning(SAXParseException exception) {
        this.logger.warn("Parsing XML at position " + exception.getLineNumber() + ", " + exception.getColumnNumber() + " :: " + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) {
        String m = "Fatal error while parsing XML, line: " + exception.getLineNumber() + " column: " + exception.getColumnNumber() + " reason: " + exception.getMessage();
        this.logger.fatal(m);
        AExceptionHandler.processException("fatal", m);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorState {
        NO_ERROR,
        IGNORED_DATA,
        UNKNOWN_TAG,
        INVALID_DATA,
        OTHER_ERROR,
        FATAL_ERROR;

    }
}

