/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils.xml;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public abstract class AXMLFileChooser
extends JFileChooser {
    private Component parent = null;

    public abstract boolean processSelectedFile(File var1);

    public AXMLFileChooser(String fileName, Component parent) {
        this.parent = parent;
        this.setFileFilter(new XMLFilter());
        if (fileName == null) {
            this.setCurrentDirectory(new File(System.getProperty("user.dir")));
        } else {
            File f = new File(fileName);
            if (f.isFile()) {
                this.setCurrentDirectory(new File(f.getAbsolutePath()));
                this.setSelectedFile(f);
            } else {
                this.setCurrentDirectory(f);
            }
        }
    }

    public void showMyDialog() {
        int state;
        while ((state = this.showOpenDialog(this.parent)) == 0) {
            File file = this.getSelectedFile();
            if (file == null) continue;
            if (this.processSelectedFile(file)) break;
            JOptionPane.showMessageDialog(this.parent, "Unable to open\n" + file, "IO Error", 0);
        }
    }

    private static class XMLFilter
    extends FileFilter {
        private XMLFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName();
            return s.toLowerCase().endsWith(".xml") || s.toLowerCase().endsWith(".zip") || s.toLowerCase().endsWith(".gzip") || s.toLowerCase().endsWith(".gz");
        }

        public String getDescription() {
            return ".xml, .zip, .gzip, .gz";
        }
    }
}

