/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils.xml;

import atlantis.Atlantis;
import atlantis.hypatia.HTrackMomentaWindow;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public abstract class AXMLGeometryChooser
extends JFileChooser {
    public AXMLGeometryChooser(String fileName) {
        int state;
        this.setFileFilter(new XMLFilter());
        this.setCurrentDirectory(new File(System.getProperty("user.dir") + Atlantis.FILE_SEPAR + "geometry"));
        if (fileName != null) {
            this.setSelectedFile(new File(System.getProperty("user.dir") + Atlantis.FILE_SEPAR + fileName));
        }
        while ((state = this.showOpenDialog(HTrackMomentaWindow.getGUI())) == 0) {
            File file = this.getSelectedFile();
            if (file == null) continue;
            if (this.processSelectedFile(file)) break;
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), "Unable to open " + file, "IO Error", 0);
        }
    }

    public AXMLGeometryChooser() {
        this((String)null);
    }

    public abstract boolean processSelectedFile(File var1);

    private static class XMLFilter
    extends FileFilter {
        private XMLFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName();
            if (s.startsWith("AMuon")) {
                return false;
            }
            if (s.equals("config.xml")) {
                return false;
            }
            if (s.equals("pdg.xml")) {
                return false;
            }
            return s.toLowerCase().lastIndexOf(".xml") == s.length() - ".xml".length();
        }

        public String getDescription() {
            return ".xml";
        }
    }
}

