/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;

public abstract class PageManager {
    private CommandProcessor commandProcessor;
    protected EventListenerList listenerList;
    private List pages = new ArrayList();
    private PageContext selected;

    public PageContext openPage(Component c, String title, Icon icon) {
        PageContext context = new PageContext(c, title, icon);
        context.setPageManager(this);
        this.pages.add(context);
        return context;
    }

    protected void setActive(boolean active) {
    }

    protected void firePageOpened(PageContext context) {
        ManagedPage mp = this.getManagedPage(context.getPage());
        if (mp != null) {
            mp.setPageContext(context);
        }
        this.firePageEvent(context, 4004);
        this.getCommandProcessor().setChanged();
    }

    ManagedPage getManagedPage(Component c) {
        Component cc;
        if (c instanceof ManagedPage) {
            return (ManagedPage)((Object)c);
        }
        if (c instanceof JScrollPane && (cc = ((JScrollPane)c).getViewport().getView()) instanceof ManagedPage) {
            return (ManagedPage)((Object)cc);
        }
        return null;
    }

    public boolean closeAll() {
        Iterator i = new ArrayList(this.pages).iterator();
        while (i.hasNext()) {
            if (this.close((PageContext)i.next())) continue;
            return false;
        }
        return true;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public PageContext getSelectedPage() {
        return this.selected;
    }

    protected abstract void show(PageContext var1);

    protected boolean close(PageContext page) {
        ManagedPage mp = this.getManagedPage(page.getPage());
        if (mp != null && !mp.close()) {
            return false;
        }
        this.pages.remove(page);
        if (page == this.selected) {
            this.fireSelectionChanged(null);
        }
        if (mp != null) {
            mp.pageClosed();
        }
        this.firePageEvent(page, 4001);
        this.getCommandProcessor().setChanged();
        return true;
    }

    protected abstract void titleChanged(PageContext var1);

    protected abstract void iconChanged(PageContext var1);

    protected abstract Component getEmbodiment();

    protected CommandProcessor createCommandProcessor() {
        return new PageManagerCommandProcessor();
    }

    protected CommandProcessor getCommandProcessor() {
        if (this.commandProcessor == null) {
            this.commandProcessor = this.createCommandProcessor();
        }
        return this.commandProcessor;
    }

    public List pages() {
        return this.pages;
    }

    protected void init(List pages, PageContext selected) {
        this.pages = pages;
        this.selected = selected;
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            PageContext page = (PageContext)i.next();
            page.setPageManager(this);
        }
    }

    protected void fireSelectionChanged(PageContext context) {
        ManagedPage mp;
        if (this.selected != null) {
            mp = this.getManagedPage(this.selected.getPage());
            if (mp != null) {
                mp.pageDeselected();
            }
            this.firePageEvent(this.selected, 4000);
        }
        this.selected = context;
        if (context != null) {
            mp = this.getManagedPage(this.selected.getPage());
            if (mp != null) {
                mp.pageSelected();
            }
            this.firePageEvent(this.selected, 3999);
        }
        this.getCommandProcessor().setChanged();
    }

    protected void firePageEvent(PageContext context, int id) {
        PageEvent event = new PageEvent(context, id);
        if (this.listenerList != null) {
            PageListener[] listeners = (PageListener[])this.listenerList.getListeners(PageListener.class);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].pageChanged(event);
            }
        }
        context.firePageEvent(event, id);
    }

    public void addPageListener(PageListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PageListener.class, listener);
    }

    public void removePageListener(PageListener listener) {
        this.listenerList.remove(PageListener.class, listener);
    }

    List getPageListenerList() {
        if (this.listenerList == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.listenerList.getListeners(PageListener.class));
    }

    void removeAllPageListeners() {
        this.listenerList = null;
    }

    public class PageManagerCommandProcessor
    extends CommandProcessor {
        public void onCloseAllPages() {
            PageManager.this.closeAll();
        }

        public void enableCloseAllPages(CommandState state) {
            state.setEnabled(PageManager.this.getPageCount() > 0);
        }

        public void onClosePage() {
            PageManager.this.close(PageManager.this.getSelectedPage());
        }

        public void enableClosePage(CommandState state) {
            state.setEnabled(PageManager.this.getSelectedPage() != null);
        }
    }
}

