/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jaco;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.freehep.jaco.generator.Generator;
import org.freehep.jaco.generator.JNIStub;
import org.freehep.jaco.generator.JNIStubImplementation;
import org.freehep.jaco.generator.JavaInterface;
import org.freehep.jaco.generator.JavaProxy;
import org.freehep.jaco.rtti.IClass;
import org.freehep.jaco.rtti.IPackage;
import org.freehep.jaco.rtti.ParseException;
import org.freehep.jaco.rtti.RTTI;
import org.freehep.jaco.rtti.cpp.CPlusPlusParser;
import org.freehep.jaco.rtti.java.JavaParser;
import org.freehep.util.argv.ArgumentFormatException;
import org.freehep.util.argv.ArgumentParser;
import org.freehep.util.argv.BooleanOption;
import org.freehep.util.argv.IntOption;
import org.freehep.util.argv.ListParameter;
import org.freehep.util.argv.MissingArgumentException;
import org.freehep.util.argv.MultiStringOption;
import org.freehep.util.argv.StringOption;

public class Jaco {
    private static String jacoVersion = "0.2";
    private static String jaco = "Java Access to C++ Objects (version " + jacoVersion + ")";
    private static RTTI rtti = new RTTI();

    public static RTTI getRTTI() {
        return rtti;
    }

    public static void main(String[] args) {
        BooleanOption help = new BooleanOption("-help", "-h", "Show this help page", true);
        BooleanOption version = new BooleanOption("-version", "-v", "Show product version", true);
        BooleanOption rtti = new BooleanOption("-rtti", "-r", "Print RTTI to stdout");
        BooleanOption noGenerate = new BooleanOption("-nogenerate", "-n", "Do not generate any code");
        StringOption directory = new StringOption("-directory", "-d", "output dir", ".", "Output into directory instead of current directory");
        StringOption pkg = new StringOption("-package", "-p", "package name", "", "Generate java code using package name");
        BooleanOption force = new BooleanOption("-force", "-f", "Force overwriting of output files");
        MultiStringOption include = new MultiStringOption("-include", "-I", "directory", "Add directory to include search path");
        IntOption cplusplus = new IntOption("-cplusplus", "c", "edition", 2, "Set edition of the C++ grammar [1..3]");
        BooleanOption ignore = new BooleanOption("-ignore", "-i", "Ignore errors from the parser");
        ListParameter headers = new ListParameter("files...", "C++ header files");
        ArgumentParser cl = new ArgumentParser("jaco");
        cl.add(help);
        cl.add(version);
        cl.add(rtti);
        cl.add(noGenerate);
        cl.add(directory);
        cl.add(pkg);
        cl.add(force);
        cl.add(include);
        cl.add(cplusplus);
        cl.add(ignore);
        cl.add(headers);
        try {
            List extra = cl.parse(args);
            if (!extra.isEmpty() || help.getValue()) {
                cl.printUsage(System.err);
                System.exit(0);
            }
            if (version.getValue()) {
                System.err.println(jaco);
                System.exit(0);
            }
        }
        catch (MissingArgumentException mae) {
            System.out.println(mae.getMessage());
            System.exit(0);
        }
        catch (ArgumentFormatException afe) {
            System.out.println(afe.getMessage());
            System.exit(0);
        }
        List files = headers.getValue();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            String filename = (String)i.next();
            try {
                JavaParser parser;
                if (filename.endsWith(".java")) {
                    System.out.println("Parsing Java: " + filename);
                    parser = new JavaParser((InputStream)new FileInputStream(filename));
                } else {
                    System.out.println("Parsing CPlusPlus: " + filename);
                    parser = new CPlusPlusParser(filename, include.getValue(), cplusplus.getInt());
                }
                parser.parse();
                parser.addGlobalClasses();
            }
            catch (FileNotFoundException e) {
                System.err.println("ERROR: File " + filename + " not found.");
                if (ignore.getValue()) continue;
                System.exit(1);
            }
            catch (ParseException e) {
                System.err.println("ERROR: Encountered errors during parse.");
                System.err.println(e.getMessage());
                if (ignore.getValue()) continue;
                System.exit(1);
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
                if (ignore.getValue()) continue;
                System.exit(1);
            }
        }
        String packagePrefix = pkg.getValue();
        if (rtti.getValue()) {
            System.out.println(Jaco.getRTTI().toString(packagePrefix));
        }
        if (noGenerate.getValue()) {
            System.out.println("No code generated.");
            System.exit(0);
        }
        boolean overwrite = force.getValue();
        try {
            String outDir = directory.getValue();
            StringBuffer s = new StringBuffer("");
            IPackage[] p = Jaco.getRTTI().getPackages();
            for (int i2 = 0; i2 < p.length; ++i2) {
                IClass[] c = p[i2].getClasses();
                for (int j = 0; j < c.length; ++j) {
                    JavaInterface generator = new JavaInterface();
                    generator.setPackagePrefix(packagePrefix);
                    Jaco.writeClass((Generator)generator, c[j], outDir, overwrite);
                    generator = new JavaProxy();
                    generator.setPackagePrefix(packagePrefix);
                    Jaco.writeClass((Generator)generator, c[j], outDir, overwrite);
                    generator = new JNIStub();
                    generator.setPackagePrefix(packagePrefix);
                    Jaco.writeClass((Generator)generator, c[j], outDir, overwrite);
                    generator = new JNIStubImplementation();
                    generator.setPackagePrefix(packagePrefix);
                    Jaco.writeClass((Generator)generator, c[j], outDir, overwrite);
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            System.exit(1);
        }
        System.exit(0);
    }

    static void writeClass(Generator generator, IClass clazz, String outDir, boolean overwrite) throws IOException {
        File dir = new File(outDir + "/" + generator.directory(clazz));
        dir.mkdirs();
        File file = new File(dir, generator.filename(clazz));
        if (!overwrite && file.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            if (line == null || line.indexOf("JACO-GENERATED") < 0) {
                throw new IOException("Non JACO-GENERATED file exists '" + file + "', cannot overwrite, use -force option");
            }
            reader.close();
        }
        System.out.println("Generating: " + file);
        generator.print(file, clazz);
    }
}

