/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.edit;

import hep.wired.edit.GraphicsPanelEdit;
import hep.wired.edit.NoOperation;
import hep.wired.edit.Rotate;
import hep.wired.edit.Scale;
import hep.wired.edit.Translate;
import hep.wired.edit.WiredCompoundEdit;
import hep.wired.feature.HasBoundingBox;
import hep.wired.feature.Rotateable3D;
import hep.wired.feature.Translateable;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import org.freehep.swing.undo.LinkableEdit;

public class FitToWindow
extends WiredCompoundEdit
implements GraphicsPanelEdit {
    private static Logger logger = Logger.getLogger(FitToWindow.class.getPackage().getName());

    public FitToWindow() {
        super("FitToWindow");
    }

    public WiredCompoundEdit copy(RecordPlot plot) {
        FitToWindow copy = new FitToWindow();
        copy.setRecordPlot(plot);
        GraphicsPanel panel = plot.getGraphicsPanel();
        Rectangle2D bbUV = ((HasBoundingBox)panel.getFeature(HasBoundingBox.class)).getBoundingBoxForPlot();
        if (bbUV == null || plot.getWidth() == 0 || plot.getHeight() == 0) {
            copy.addEdit((LinkableEdit)new NoOperation().copy(plot));
            copy.end();
            return copy;
        }
        double du = bbUV.getX() + bbUV.getWidth() / 2.0 - (double)(plot.getWidth() / 2);
        double dv = bbUV.getY() + bbUV.getHeight() / 2.0 - (double)(plot.getHeight() / 2);
        double dz = 0.0;
        if (panel.supports(Rotateable3D.class)) {
            RecordPlot wvPlot = plot;
            wvPlot.postEdit((UndoableEdit)((Object)new Rotate(1.5707963267948966, 0.0, 1.0, 0.0)));
            Rectangle2D bbWV = ((HasBoundingBox)wvPlot.getGraphicsPanel().getFeature(HasBoundingBox.class)).getBoundingBoxForPlot();
            dz = bbWV.getX() + bbWV.getWidth() / 2.0 - (double)(plot.getWidth() / 2);
            wvPlot.postEdit((UndoableEdit)((Object)new Rotate(-1.5707963267948966, 0.0, 1.0, 0.0)));
        }
        Translateable translateable = (Translateable)plot.getGraphicsPanel().getFeature(Translateable.class);
        double[] t = translateable.getModelTranslation(new double[]{-du, dv, -dz}, plot.getGraphicsPanel().getViewPort());
        Translate translate = new Translate(t[0], t[1], t[2], bbUV, 5);
        Shape shape = translate.createTransformedShape((Component)((Object)plot), bbUV);
        copy.addEdit((LinkableEdit)translate.copy(plot));
        double sx = (double)plot.getWidth() / (bbUV.getWidth() + 1.0);
        double sy = (double)plot.getHeight() / (bbUV.getHeight() + 1.0);
        double s = Math.min(sx, sy);
        copy.addEdit((LinkableEdit)new Scale(s, s, s, shape, 5).copy(plot));
        copy.end();
        return copy;
    }

    public boolean isSupportedBy(GraphicsPanel p) {
        Translate t = new Translate();
        Scale s = new Scale();
        return t.isSupportedBy(p) && s.isSupportedBy(p);
    }

    public boolean addEdit(UndoableEdit edit) {
        if (edit instanceof FitToWindow) {
            return true;
        }
        return super.addEdit(edit);
    }
}

