/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.edit;

import hep.wired.edit.GraphicsPanelEdit;
import hep.wired.edit.WiredEdit;
import hep.wired.feature.Resetable;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;

public class Reset
extends WiredEdit
implements GraphicsPanelEdit {
    private static Logger logger = Logger.getLogger(Reset.class.getPackage().getName());
    private Object oldState = null;

    public WiredEdit copy(RecordPlot plot) {
        Reset copy = new Reset();
        copy.setRecordPlot(plot);
        return copy;
    }

    public String getPresentationName() {
        return "Reset";
    }

    public boolean addEdit(UndoableEdit edit) {
        if (edit instanceof Reset) {
            return true;
        }
        return super.addEdit(edit);
    }

    public boolean isSupportedBy(GraphicsPanel p) {
        return p.getFeature(Resetable.class) != null;
    }

    protected void redoEdit() {
        Resetable resetable = (Resetable)this.getRecordPlot().getGraphicsPanel().getFeature(Resetable.class);
        if (resetable != null) {
            this.oldState = resetable.reset(this.oldState);
            this.getRecordPlot().repaint();
        }
        logger.finer(this.toString());
    }

    protected void undoEdit() {
        Resetable resetable = (Resetable)this.getRecordPlot().getGraphicsPanel().getFeature(Resetable.class);
        if (resetable != null) {
            this.oldState = resetable.reset(this.oldState);
            this.getRecordPlot().repaint();
        }
        logger.finer(this.toString());
    }
}

