/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.edit;

import hep.wired.edit.AnimatedWiredEdit;
import hep.wired.edit.GraphicsPanelEdit;
import hep.wired.edit.WiredEdit;
import hep.wired.feature.Rotateable2D;
import hep.wired.feature.Rotateable3D;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import hep.wired.util.Matrix3D;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;

public class Rotate
extends AnimatedWiredEdit
implements GraphicsPanelEdit {
    private static Logger logger = Logger.getLogger(Rotate.class.getPackage().getName());
    private double nx;
    private double ny;
    private double nz;
    private double theta;
    private Matrix3D matrix;

    public Rotate() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public Rotate(double theta, double nx, double ny, double nz) {
        this(theta, nx, ny, nz, null, 0);
    }

    public Rotate(double theta, double nx, double ny, double nz, Shape shape, int frames) {
        super(shape, frames);
        this.matrix = Matrix3D.getRotateInstance(theta, nx, ny, nz);
        this.theta = theta;
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
    }

    public WiredEdit copy(RecordPlot plot) {
        Rotate copy = new Rotate(this.theta, this.nx, this.ny, this.nz, this.getShape(), this.getFrames());
        copy.setRecordPlot(plot);
        return copy;
    }

    protected Shape[] getShapes(Shape shape, int steps) {
        if (shape == null || steps <= 1) {
            return null;
        }
        if (this.nx != 0.0 || this.ny != 0.0 || this.nz != 1.0) {
            return null;
        }
        Shape[] shapes = new Shape[steps];
        double dtheta = this.theta / (double)(steps - 1);
        double w = (double)this.getRecordPlot().getWidth() / 2.0;
        double h = (double)this.getRecordPlot().getHeight() / 2.0;
        for (int i = 0; i < steps; ++i) {
            AffineTransform transform = new AffineTransform();
            transform.rotate((double)(-i) * dtheta, w, h);
            shapes[i] = transform.createTransformedShape(shape);
        }
        return shapes;
    }

    public Shape createTransformedShape(Component component, Shape shape) {
        if (this.nx != 0.0 || this.ny != 0.0 || this.nz != 1.0) {
            return null;
        }
        double w = (double)component.getWidth() / 2.0;
        double h = (double)component.getHeight() / 2.0;
        AffineTransform transform = new AffineTransform();
        transform.rotate(-this.theta, w, h);
        return transform.createTransformedShape(shape);
    }

    public String getPresentationName() {
        double[] n = new double[3];
        double theta = this.matrix.getRotation(n);
        return this.toString() + " " + format.format(Math.toDegrees(theta)) + " degrees over (" + format.format(n[0]) + ", " + format.format(n[1]) + ", " + format.format(n[2]) + ")";
    }

    public String toString() {
        return "Rotate";
    }

    public boolean addEdit(UndoableEdit edit) {
        if (edit instanceof Rotate) {
            Rotate rotate = (Rotate)((Object)edit);
            this.matrix.preConcatenate(rotate.matrix);
            rotate.matrix = this.matrix = this.matrix.createOrthonormalized();
            return false;
        }
        return false;
    }

    public boolean isSupportedBy(GraphicsPanel p) {
        return p.supports(Rotateable2D.class) || p.supports(Rotateable3D.class);
    }

    protected void redoEdit() {
        GraphicsPanel panel = this.getRecordPlot().getGraphicsPanel();
        Rotateable3D rotateable3D = (Rotateable3D)panel.getFeature(Rotateable3D.class);
        if (rotateable3D != null) {
            rotateable3D.rotate(this.theta, this.nx, this.ny, this.nz);
        } else {
            Rotateable2D rotateable2D = (Rotateable2D)panel.getFeature(Rotateable2D.class);
            if (rotateable2D == null) {
                System.err.println("Could not redo: " + this);
                return;
            }
            rotateable2D.rotate(this.theta);
        }
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }

    protected void undoEdit() {
        GraphicsPanel panel = this.getRecordPlot().getGraphicsPanel();
        Rotateable3D rotateable3D = (Rotateable3D)panel.getFeature(Rotateable3D.class);
        if (rotateable3D != null) {
            rotateable3D.rotate(-this.theta, this.nx, this.ny, this.nz);
        } else {
            Rotateable2D rotateable2D = (Rotateable2D)panel.getFeature(Rotateable2D.class);
            if (rotateable2D == null) {
                System.err.println("Could not undo: " + this);
                return;
            }
            rotateable2D.rotate(-this.theta);
        }
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }
}

