/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.edit;

import hep.wired.edit.AnimatedWiredEdit;
import hep.wired.edit.GraphicsPanelEdit;
import hep.wired.edit.WiredEdit;
import hep.wired.feature.Scaleable;
import hep.wired.feature.Scaleable2D;
import hep.wired.feature.Scaleable3D;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;

public class Scale
extends AnimatedWiredEdit
implements GraphicsPanelEdit {
    private static Logger logger = Logger.getLogger(Scale.class.getPackage().getName());
    private double sx;
    private double sy;
    private double sz;

    public Scale() {
        this(1.0);
    }

    public Scale(double s) {
        this(s, s);
    }

    public Scale(double sx, double sy) {
        this(sx, sy, 1.0);
    }

    public Scale(double sx, double sy, double sz) {
        this(sx, sy, sz, null, 0);
    }

    public Scale(double sx, double sy, double sz, Shape shape, int frames) {
        super(shape, frames);
        this.sx = sx;
        this.sy = sy;
        this.sz = sz;
    }

    public WiredEdit copy(RecordPlot plot) {
        Scale copy = new Scale(this.sx, this.sy, this.sz, this.getShape(), this.getFrames());
        copy.setRecordPlot(plot);
        return copy;
    }

    protected Shape[] getShapes(Shape shape, int steps) {
        if (shape == null || steps <= 1) {
            return null;
        }
        Shape[] shapes = new Shape[steps];
        double dsx = (this.sx - 1.0) / (double)(steps - 1);
        double dsy = (this.sy - 1.0) / (double)(steps - 1);
        double w = (double)this.getRecordPlot().getWidth() / 2.0;
        double h = (double)this.getRecordPlot().getHeight() / 2.0;
        for (int i = 0; i < steps; ++i) {
            AffineTransform transform = new AffineTransform();
            transform.translate(w, h);
            transform.scale(1.0 + (double)i * dsx, 1.0 + (double)i * dsy);
            transform.translate(-w, -h);
            shapes[i] = transform.createTransformedShape(shape);
        }
        return shapes;
    }

    public Shape createTransformedShape(Component component, Shape shape) {
        double w = (double)component.getWidth() / 2.0;
        double h = (double)component.getHeight() / 2.0;
        AffineTransform transform = new AffineTransform();
        transform.translate(w, h);
        transform.scale(this.sx, this.sy);
        transform.translate(-w, -h);
        return transform.createTransformedShape(shape);
    }

    public String getPresentationName() {
        StringBuffer s = new StringBuffer();
        s.append(this.toString());
        s.append(" (");
        s.append(format.format(this.sx));
        if (this.sy != 1.0 || this.sz != 1.0) {
            s.append(", ");
            s.append(format.format(this.sy));
        }
        if (this.sz != 1.0) {
            s.append(", ");
            s.append(format.format(this.sz));
        }
        s.append(")");
        return s.toString();
    }

    public String toString() {
        return "Scale";
    }

    public boolean addEdit(UndoableEdit edit) {
        if (edit instanceof Scale) {
            Scale scale = (Scale)((Object)edit);
            this.sx *= scale.sx;
            this.sy *= scale.sy;
            this.sz *= scale.sz;
            return true;
        }
        return false;
    }

    public boolean isSupportedBy(GraphicsPanel p) {
        return p.supports(Scaleable.class) || p.supports(Scaleable2D.class) || p.supports(Scaleable3D.class);
    }

    protected void redoEdit() {
        GraphicsPanel panel = this.getRecordPlot().getGraphicsPanel();
        Scaleable3D scaleable3D = (Scaleable3D)panel.getFeature(Scaleable3D.class);
        if (scaleable3D != null) {
            scaleable3D.scale(this.sx, this.sy, this.sz);
        } else {
            Scaleable2D scaleable2D = (Scaleable2D)panel.getFeature(Scaleable2D.class);
            if (scaleable2D != null) {
                scaleable2D.scale(this.sx, this.sy);
            } else {
                Scaleable scaleable = (Scaleable)panel.getFeature(Scaleable.class);
                if (scaleable != null) {
                    scaleable.scale(this.sx);
                } else {
                    System.err.println("Could not redo: " + this);
                    return;
                }
            }
        }
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }

    protected void undoEdit() {
        GraphicsPanel panel = this.getRecordPlot().getGraphicsPanel();
        Scaleable3D scaleable3D = (Scaleable3D)panel.getFeature(Scaleable3D.class);
        if (scaleable3D != null) {
            scaleable3D.scale(1.0 / this.sx, 1.0 / this.sy, 1.0 / this.sz);
        } else {
            Scaleable2D scaleable2D = (Scaleable2D)panel.getFeature(Scaleable2D.class);
            if (scaleable2D != null) {
                scaleable2D.scale(1.0 / this.sx, 1.0 / this.sy);
            } else {
                Scaleable scaleable = (Scaleable)panel.getFeature(Scaleable.class);
                if (scaleable != null) {
                    scaleable.scale(1.0 / this.sx);
                } else {
                    System.err.println("Could not undo: " + this);
                    return;
                }
            }
        }
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }
}

