/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.edit;

import hep.wired.edit.AnimatedWiredEdit;
import hep.wired.edit.GraphicsPanelEdit;
import hep.wired.edit.WiredEdit;
import hep.wired.feature.Shearable2D;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;

public class Shear
extends AnimatedWiredEdit
implements GraphicsPanelEdit {
    private static Logger logger = Logger.getLogger(Shear.class.getPackage().getName());
    private double shx;
    private double shy;

    public Shear() {
        this(0.0, 0.0);
    }

    public Shear(double shx, double shy) {
        this(shx, shy, null, 0);
    }

    public Shear(double shx, double shy, Shape shape, int frames) {
        super(shape, frames);
        this.shx = shx;
        this.shy = shy;
    }

    public WiredEdit copy(RecordPlot plot) {
        Shear copy = new Shear(this.shx, this.shy, this.getShape(), this.getFrames());
        copy.setRecordPlot(plot);
        return copy;
    }

    protected Shape[] getShapes(Shape shape, int steps) {
        if (shape == null || steps <= 1) {
            return null;
        }
        Shape[] shapes = new Shape[steps];
        double dshx = this.shx / (double)(steps - 1);
        double dshy = this.shy / (double)(steps - 1);
        double w = (double)this.getRecordPlot().getWidth() / 2.0;
        double h = (double)this.getRecordPlot().getHeight() / 2.0;
        for (int i = 0; i < steps; ++i) {
            AffineTransform transform = new AffineTransform();
            transform.translate(w, h);
            transform.shear((double)(-i) * dshx, (double)(-i) * dshy);
            transform.translate(-w, -h);
            shapes[i] = transform.createTransformedShape(shape);
        }
        return shapes;
    }

    public Shape createTransformedShape(Component component, Shape shape) {
        double w = (double)component.getWidth() / 2.0;
        double h = (double)component.getHeight() / 2.0;
        AffineTransform transform = new AffineTransform();
        transform.translate(w, h);
        transform.shear(-this.shx, -this.shy);
        transform.translate(-w, -h);
        return transform.createTransformedShape(shape);
    }

    public String getPresentationName() {
        return this.toString() + " (" + format.format(this.shx) + ", " + format.format(this.shy) + ")";
    }

    public String toString() {
        return "Shear";
    }

    public boolean addEdit(UndoableEdit edit) {
        if (edit instanceof Shear) {
            Shear shear = (Shear)((Object)edit);
            this.shx *= shear.shx;
            this.shy *= shear.shy;
            return true;
        }
        return false;
    }

    public boolean isSupportedBy(GraphicsPanel p) {
        return p.supports(Shearable2D.class);
    }

    protected void redoEdit() {
        Shearable2D shearable = (Shearable2D)this.getRecordPlot().getGraphicsPanel().getFeature(Shearable2D.class);
        if (shearable == null) {
            System.err.println("Could not redo: " + this);
            return;
        }
        shearable.shear(this.shx, this.shy);
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }

    protected void undoEdit() {
        Shearable2D shearable = (Shearable2D)this.getRecordPlot().getGraphicsPanel().getFeature(Shearable2D.class);
        if (shearable == null) {
            System.err.println("Could not undo: " + this);
            return;
        }
        shearable.shear(this.shx == 0.0 ? 0.0 : 1.0 / this.shx, this.shy == 0.0 ? 0.0 : 1.0 / this.shy);
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }
}

