/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.edit;

import hep.wired.edit.AnimatedWiredEdit;
import hep.wired.edit.GraphicsPanelEdit;
import hep.wired.edit.WiredEdit;
import hep.wired.feature.Transformable2D;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;

public class Transform2D
extends AnimatedWiredEdit
implements GraphicsPanelEdit {
    private static Logger logger = Logger.getLogger(Transform2D.class.getPackage().getName());
    private double sx;
    private double shy;
    private double shx;
    private double sy;
    private double tx;
    private double ty;

    public Transform2D() {
        this(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public Transform2D(double sx, double shy, double shx, double sy, double tx, double ty) {
        this(sx, shy, shx, sy, tx, ty, null, 0);
    }

    public Transform2D(double sx, double shy, double shx, double sy, double tx, double ty, Shape shape, int frames) {
        super(shape, frames);
        this.sx = sx;
        this.shy = shy;
        this.shx = shx;
        this.sy = sy;
        this.tx = tx;
        this.ty = ty;
    }

    public WiredEdit copy(RecordPlot plot) {
        Transform2D copy = new Transform2D(this.sx, this.shy, this.shx, this.sy, this.tx, this.ty, this.getShape(), this.getFrames());
        copy.setRecordPlot(plot);
        return copy;
    }

    protected Shape[] getShapes(Shape shape, int steps) {
        if (shape == null || steps <= 1) {
            return null;
        }
        Shape[] shapes = new Shape[steps];
        double dsx = (this.sx - 1.0) / (double)(steps - 1);
        double dsy = (this.sy - 1.0) / (double)(steps - 1);
        double dshx = this.shx / (double)(steps - 1);
        double dshy = this.shy / (double)(steps - 1);
        double dtx = this.tx / (double)(steps - 1);
        double dty = this.ty / (double)(steps - 1);
        double w = (double)this.getRecordPlot().getWidth() / 2.0;
        double h = (double)this.getRecordPlot().getHeight() / 2.0;
        for (int i = 0; i < steps; ++i) {
            AffineTransform transform = new AffineTransform();
            transform.translate(w, h);
            transform.scale(1.0 + (double)i * dsx, 1.0 + (double)i * dsy);
            transform.shear((double)(-i) * dshx, (double)(-i) * dshy);
            transform.translate((double)(-i) * dtx, (double)i * dty);
            transform.translate(-w, -h);
            shapes[i] = transform.createTransformedShape(shape);
        }
        return shapes;
    }

    public Shape createTransformedShape(Component component, Shape shape) {
        double w = (double)component.getWidth() / 2.0;
        double h = (double)component.getHeight() / 2.0;
        AffineTransform transform = new AffineTransform();
        transform.translate(w, h);
        transform.scale(this.sx, this.sy);
        transform.shear(-this.shx, -this.shy);
        transform.translate(-this.tx, this.ty);
        transform.translate(-w, -h);
        return transform.createTransformedShape(shape);
    }

    public String getPresentationName() {
        return "Transform2D";
    }

    public boolean addEdit(UndoableEdit edit) {
        if (edit instanceof Transform2D) {
            return false;
        }
        return false;
    }

    public boolean isSupportedBy(GraphicsPanel p) {
        return p.supports(Transformable2D.class);
    }

    protected void redoEdit() {
        Transformable2D transformable2D = (Transformable2D)this.getRecordPlot().getGraphicsPanel().getFeature(Transformable2D.class);
        if (transformable2D == null) {
            System.err.println("Could not redo: " + this);
            return;
        }
        transformable2D.scale(this.sx, this.sy);
        transformable2D.shear(this.shx, this.shy);
        transformable2D.translate(this.tx, this.ty);
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }

    protected void undoEdit() {
        Transformable2D transformable2D = (Transformable2D)this.getRecordPlot().getGraphicsPanel().getFeature(Transformable2D.class);
        if (transformable2D == null) {
            System.err.println("Could not undo: " + this);
            return;
        }
        transformable2D.translate(-this.tx, -this.ty);
        transformable2D.shear(-this.shx, -this.shy);
        transformable2D.scale(1.0 / this.sx, 1.0 / this.sy);
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }

    public String toString() {
        return super.toString() + "; (" + this.sx + ", " + this.shy + ", " + this.shx + ", " + this.sy + ", " + this.tx + ", " + this.ty + ")";
    }
}

