/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.edit;

import hep.wired.edit.AnimatedWiredEdit;
import hep.wired.edit.GraphicsPanelEdit;
import hep.wired.edit.WiredEdit;
import hep.wired.feature.Translateable;
import hep.wired.feature.Translateable2D;
import hep.wired.feature.Translateable3D;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import hep.wired.util.XYZandUVWindices;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;

public class Translate
extends AnimatedWiredEdit
implements GraphicsPanelEdit,
XYZandUVWindices {
    private static Logger logger = Logger.getLogger(Translate.class.getPackage().getName());
    private double tx;
    private double ty;
    private double tz;

    public Translate() {
        this(0.0, 0.0, 0.0);
    }

    public Translate(double tx, double ty, double tz) {
        this(tx, ty, tz, null, 0);
    }

    public Translate(double tx, double ty, double tz, Shape shape, int frames) {
        super(shape, frames);
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
    }

    public WiredEdit copy(RecordPlot plot) {
        Translate copy = new Translate(this.tx, this.ty, this.tz, this.getShape(), this.getFrames());
        copy.setRecordPlot(plot);
        return copy;
    }

    protected Shape[] getShapes(Shape shape, int steps) {
        if (shape == null || steps <= 1) {
            return null;
        }
        Shape[] shapes = new Shape[steps];
        GraphicsPanel panel = this.getRecordPlot().getGraphicsPanel();
        Translateable translateable = (Translateable)panel.getFeature(Translateable.class);
        double[] uvw = translateable.getScreenTranslation(new double[]{this.tx / (double)(steps - 1), this.ty / (double)(steps - 1), this.tz / (double)(steps - 1)}, panel.getViewPort());
        AffineTransform transform = new AffineTransform();
        for (int i = 0; i < steps; ++i) {
            shapes[i] = transform.createTransformedShape(shape);
            transform.translate(uvw[0], -uvw[1]);
        }
        return shapes;
    }

    public Shape createTransformedShape(Component component, Shape shape) {
        RecordPlot plot = (RecordPlot)((Object)component);
        GraphicsPanel panel = plot.getGraphicsPanel();
        Translateable translateable = (Translateable)panel.getFeature(Translateable.class);
        double[] uvw = translateable.getScreenTranslation(new double[]{this.tx, this.ty, this.tz}, panel.getViewPort());
        return AffineTransform.getTranslateInstance(uvw[0], -uvw[1]).createTransformedShape(shape);
    }

    public String getPresentationName() {
        StringBuffer s = new StringBuffer();
        s.append(this.toString());
        s.append(" (");
        s.append(format.format(this.tx));
        s.append(", ");
        s.append(format.format(this.ty));
        if (this.tz != 0.0) {
            s.append(", ");
            s.append(format.format(this.tz));
        }
        s.append(")");
        return s.toString();
    }

    public String toString() {
        return "Translate";
    }

    public boolean addEdit(UndoableEdit edit) {
        if (edit instanceof Translate) {
            Translate translate = (Translate)((Object)edit);
            this.tx += translate.tx;
            this.ty += translate.ty;
            this.tz += translate.tz;
            return true;
        }
        return false;
    }

    public boolean isSupportedBy(GraphicsPanel p) {
        return p.supports(Translateable2D.class) || p.supports(Translateable3D.class);
    }

    protected void redoEdit() {
        GraphicsPanel panel = this.getRecordPlot().getGraphicsPanel();
        Translateable3D translateable3D = (Translateable3D)panel.getFeature(Translateable3D.class);
        if (translateable3D != null) {
            translateable3D.translate(this.tx, this.ty, this.tz);
        } else {
            Translateable2D translateable2D = (Translateable2D)panel.getFeature(Translateable2D.class);
            if (translateable2D == null) {
                System.err.println("Could not redo: " + this);
                return;
            }
            translateable2D.translate(this.tx, this.ty);
        }
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }

    protected void undoEdit() {
        GraphicsPanel panel = this.getRecordPlot().getGraphicsPanel();
        Translateable3D translateable3D = (Translateable3D)panel.getFeature(Translateable3D.class);
        if (translateable3D != null) {
            translateable3D.translate(-this.tx, -this.ty, -this.tz);
        } else {
            Translateable2D translateable2D = (Translateable2D)panel.getFeature(Translateable2D.class);
            if (translateable2D == null) {
                System.err.println("Could not undo: " + this);
                return;
            }
            translateable2D.translate(-this.tx, -this.ty);
        }
        this.getRecordPlot().repaint();
        logger.finer(this.toString());
    }
}

