/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.interaction;

import hep.wired.edit.Scale;
import hep.wired.edit.Translate;
import hep.wired.interaction.AbstractInteractionHandler;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.undo.UndoableEdit;

public class DefaultInteractionHandler
extends AbstractInteractionHandler {
    private static DefaultInteractionHandler instance;
    protected static final double fixedScale;
    protected static final double multiplyScale = 3.0;
    protected static final double fixedTranslate = 1000.0;
    protected static final double multiplyTranslate = 10.0;

    protected DefaultInteractionHandler(String name) {
        super(name);
    }

    public static DefaultInteractionHandler getInstance() {
        if (instance == null) {
            instance = new DefaultInteractionHandler("Default");
        }
        return instance;
    }

    public String getDescription() {
        return "Move mousewheel to zoom in/out; Use cursor keys to translate.";
    }

    public boolean isSupportedBy(GraphicsPanel panel) {
        return true;
    }

    public void changeCursor(RecordPlot plot, InputEvent event) {
        plot.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseEntered(RecordPlot plot, MouseEvent event) {
        plot.requestFocusInWindow();
        this.changeCursor(plot, event);
    }

    public void mouseWheelMoved(RecordPlot plot, MouseWheelEvent event) {
        if (!plot.supports((UndoableEdit)((Object)new Scale()))) {
            return;
        }
        double scale = fixedScale - 1.0;
        scale *= event.isShiftDown() ? 3.0 : 1.0;
        scale *= event.isControlDown() ? 0.3333333333333333 : 1.0;
        scale += 1.0;
        double clicks = event.getWheelRotation();
        scale = scale < 0.0 ? 1.0 / -scale : (scale *= clicks);
        plot.postEdit((UndoableEdit)((Object)new Scale(scale, scale, scale)));
    }

    public boolean otherKeyPressed(RecordPlot plot, KeyEvent event) {
        switch (event.getKeyCode()) {
            case 38: 
            case 224: {
                this.translate(plot, event, 0.0, 1000.0);
                return true;
            }
            case 40: 
            case 225: {
                this.translate(plot, event, 0.0, -1000.0);
                return true;
            }
            case 37: 
            case 226: {
                this.translate(plot, event, -1000.0, 0.0);
                return true;
            }
            case 39: 
            case 227: {
                this.translate(plot, event, 1000.0, 0.0);
                return true;
            }
            case 107: 
            case 521: {
                if (plot.supports((UndoableEdit)((Object)new Scale()))) {
                    plot.postEdit((UndoableEdit)((Object)new Scale(fixedScale, fixedScale, fixedScale)));
                }
                return true;
            }
            case 45: 
            case 109: {
                if (plot.supports((UndoableEdit)((Object)new Scale()))) {
                    plot.postEdit((UndoableEdit)((Object)new Scale(1.0 / fixedScale, 1.0 / fixedScale, 1.0 / fixedScale)));
                }
                return true;
            }
        }
        return false;
    }

    private void translate(RecordPlot plot, InputEvent event, double dx, double dy) {
        if (!plot.supports((UndoableEdit)((Object)new Translate()))) {
            return;
        }
        if (event.isControlDown()) {
            dx /= 10.0;
            dy /= 10.0;
        }
        if (event.isShiftDown()) {
            dx *= 10.0;
            dy *= 10.0;
        }
        plot.postEdit((UndoableEdit)((Object)new Translate(dx, dy, 0.0)));
    }

    static {
        fixedScale = Math.sqrt(2.0);
    }
}

