/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.interaction;

import hep.wired.edit.Rotate;
import hep.wired.edit.Scale;
import hep.wired.edit.Transform2D;
import hep.wired.edit.Translate;
import hep.wired.edit.WiredCompoundEdit;
import hep.wired.feature.Translateable;
import hep.wired.image.WiredBaseImage;
import hep.wired.interaction.DefaultInteractionHandler;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.Component;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.Icon;
import javax.swing.undo.UndoableEdit;
import org.freehep.application.Application;
import org.freehep.swing.undo.LinkableEdit;
import org.freehep.util.DiscreteAngle;

public class DragAngledRectangleToScale
extends DefaultInteractionHandler {
    private static final String name = "Combined Transformation";
    private static final int cursorSize = 32;
    private boolean fixedRatio = true;
    private int n;
    private int[] x = new int[3];
    private int[] y = new int[3];
    private int xp;
    private int yp;
    private DiscreteAngle angle;
    private Double perpAngle1;
    private Double perpAngle2;
    private GeneralPath path;

    public DragAngledRectangleToScale() {
        super("Drag Angled Rectangle to Scale");
    }

    public Icon getIcon(int size) {
        return WiredBaseImage.getIcon("AngledRectangle%w", size);
    }

    public String getDescription() {
        return "Click to define first point of angled rectangle.";
    }

    public boolean isSupportedBy(GraphicsPanel panel) {
        return new Scale().isSupportedBy(panel) && new Transform2D().isSupportedBy(panel) && new Translate().isSupportedBy(panel) && new Rotate().isSupportedBy(panel);
    }

    public void changeCursor(RecordPlot plot, InputEvent event) {
        if (this.n == 2 && !event.isControlDown()) {
            if (this.x[2] == this.x[1]) {
                plot.setCursor(WiredBaseImage.getBestCursor("YSkewCursor%w", 32, 32));
            } else if (this.y[2] == this.y[1]) {
                plot.setCursor(WiredBaseImage.getBestCursor("XSkewCursor%w", 32, 32));
            } else {
                plot.setCursor(WiredBaseImage.getBestCursor("AngledRectangleCursor%w", 32, 32));
            }
        } else {
            plot.setCursor(WiredBaseImage.getBestCursor("AngledRectangleCursor%w", 32, 32));
        }
    }

    public void reset(RecordPlot plot, InputEvent event) {
        this.n = 0;
        plot.drawShape(null);
        this.changeCursor(plot, event);
        Application.getApplication().setStatusMessage(this.getDescription());
    }

    public void mouseEntered(RecordPlot plot, MouseEvent event) {
        plot.requestFocusInWindow();
        this.changeCursor(plot, event);
    }

    public void mouseButton1Clicked(RecordPlot plot, MouseEvent event) {
        this.definePoint(plot, event);
        this.pinPoint(plot, event);
    }

    public void mouseButton1DragStarted(RecordPlot plot, MouseEvent event) {
        this.definePoint(plot, event);
        if (this.n < 2) {
            this.pinPoint(plot, event);
        }
    }

    public void mouseButton1Dragged(RecordPlot plot, MouseEvent event) {
        if (this.n > 0) {
            this.definePoint(plot, event);
        }
    }

    public void mouseButton1DragEnded(RecordPlot plot, MouseEvent event) {
        this.definePoint(plot, event);
        this.pinPoint(plot, event);
    }

    public void mouseMoved(RecordPlot plot, MouseEvent event) {
        this.mouseButton1Dragged(plot, event);
    }

    public boolean shiftKeyPressed(RecordPlot plot, KeyEvent event) {
        this.modifyPoint(plot, event);
        return true;
    }

    public boolean shiftKeyReleased(RecordPlot plot, KeyEvent event) {
        this.modifyPoint(plot, event);
        return true;
    }

    public boolean ctrlKeyPressed(RecordPlot plot, KeyEvent event) {
        this.modifyPoint(plot, event);
        return true;
    }

    public boolean ctrlKeyReleased(RecordPlot plot, KeyEvent event) {
        this.modifyPoint(plot, event);
        return true;
    }

    private void definePoint(RecordPlot plot, MouseEvent event) {
        this.xp = event.getX();
        this.yp = event.getY();
        switch (this.n) {
            case 0: {
                this.x[1] = this.x[2] = this.xp;
                this.x[0] = this.x[2];
                this.y[1] = this.y[2] = this.yp;
                this.y[0] = this.y[2];
                break;
            }
            case 1: {
                this.x[1] = this.x[2] = this.xp;
                this.y[1] = this.y[2] = this.yp;
                plot.drawShape(new Line2D.Double(this.x[0], this.y[0], this.x[1], this.y[1]));
                break;
            }
            case 2: {
                this.x[2] = this.xp;
                this.y[2] = this.yp;
                this.modifyPoint(plot, event);
                break;
            }
            default: {
                this.finished(plot, event);
            }
        }
    }

    private void modifyPoint(RecordPlot plot, InputEvent event) {
        int dy;
        int dx;
        if (this.n != 2) {
            return;
        }
        if (!event.isControlDown()) {
            dx = this.xp - this.x[1];
            dy = this.yp - this.y[1];
            double alpha = (Math.atan2(dy, dx) + Math.PI * 2) % (Math.PI * 2);
            double beta = this.angle.getAngle(alpha);
            double cosBeta = Math.cos(beta);
            double sinBeta = Math.sin(beta);
            double h1 = Math.abs(cosBeta < 0.1 ? (double)dx : (double)dx / cosBeta);
            double h2 = Math.abs(sinBeta < 0.1 ? (double)dy : (double)dy / sinBeta);
            double height2 = Math.max(h1, h2);
            if (!event.isShiftDown()) {
                int wx = this.x[1] - this.x[0];
                int wy = this.y[1] - this.y[0];
                double width = Math.sqrt(wx * wx + wy * wy);
                double ratio = (double)plot.getHeight() / (double)plot.getWidth();
                height2 = ratio * width / 2.0;
                this.fixedRatio = true;
            } else {
                this.fixedRatio = false;
            }
            this.x[2] = (int)(height2 * cosBeta + (double)this.x[1]);
            this.y[2] = (int)(height2 * sinBeta + (double)this.y[1]);
        } else {
            this.x[2] = this.xp;
            this.y[2] = this.yp;
        }
        dx = this.x[2] - this.x[1];
        dy = this.y[2] - this.y[1];
        this.path = new GeneralPath();
        this.path.moveTo(this.x[0], this.y[0]);
        this.path.lineTo(this.x[1], this.y[1]);
        this.path.moveTo(this.x[0] + dx, this.y[0] + dy);
        this.path.lineTo(this.x[1] + dx, this.y[1] + dy);
        this.path.lineTo(this.x[1] - dx, this.y[1] - dy);
        this.path.lineTo(this.x[0] - dx, this.y[0] - dy);
        this.path.closePath();
        plot.drawShape(this.path);
        this.changeCursor(plot, event);
    }

    private void pinPoint(RecordPlot plot, InputEvent event) {
        switch (this.n) {
            case 0: {
                Application.getApplication().setStatusMessage("Click to define angle of angled rectangle.");
                this.angle = new DiscreteAngle();
                this.angle.addAngle(0.0);
                this.angle.addAngle(1.5707963267948966);
                this.angle.addAngle(Math.PI);
                this.angle.addAngle(4.71238898038469);
                this.angle.addAngle(Math.PI * 2);
                ++this.n;
                break;
            }
            case 1: {
                Application.getApplication().setStatusMessage("Click to define rectangle, Shift removes ratio constraint, Ctrl removes angle and ratio constraint.");
                double perp = (Math.atan2(this.y[1] - this.y[0], this.x[1] - this.x[0]) + 4.71238898038469) % (Math.PI * 2);
                this.perpAngle1 = this.angle.addAngle(perp);
                this.perpAngle2 = this.angle.addAngle((perp + Math.PI) % (Math.PI * 2));
                ++this.n;
                break;
            }
            case 2: {
                this.finished(plot, event);
                this.n = 0;
                break;
            }
        }
    }

    private void finished(RecordPlot plot, InputEvent event) {
        WiredCompoundEdit edit = new WiredCompoundEdit(name);
        int dx1 = this.x[1] - this.x[0];
        int dy1 = this.y[1] - this.y[0];
        int dx2 = this.x[2] - this.x[1];
        int dy2 = this.y[2] - this.y[1];
        double w = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double h = Math.sqrt(dx2 * dx2 + dy2 * dy2) * 2.0;
        int w2 = plot.getWidth() / 2;
        int h2 = plot.getHeight() / 2;
        if (w != 0.0 && h != 0.0) {
            int dx = dx1 / 2 + this.x[0] - w2;
            int dy = dy1 / 2 + this.y[0] - h2;
            Translateable translateable = (Translateable)plot.getGraphicsPanel().getFeature(Translateable.class);
            double[] t = translateable.getModelTranslation(new double[]{-dx, dy, 0.0}, plot.getGraphicsPanel().getViewPort());
            Translate translate = new Translate(t[0], t[1], t[2], this.path, 5);
            Shape shape = translate.createTransformedShape((Component)((Object)plot), this.path);
            edit.addEdit((LinkableEdit)translate);
            double alpha = Math.atan2(dy1, dx1);
            if (alpha > 1.5707963267948966) {
                alpha -= Math.PI;
            }
            if (alpha <= -1.5707963267948966) {
                alpha += Math.PI;
            }
            Rotate rotate = new Rotate(alpha, 0.0, 0.0, 1.0, shape, 5);
            shape = rotate.createTransformedShape((Component)((Object)plot), shape);
            edit.addEdit((LinkableEdit)rotate);
            double beta = Math.atan2(dy2, dx2);
            double delta = 1.5707963267948966 - beta + alpha;
            if (delta > 1.5707963267948966) {
                delta -= Math.PI;
            }
            if (delta <= -1.5707963267948966) {
                delta += Math.PI;
            }
            double shx = Math.tan(delta);
            double esy = h / (h * Math.cos(delta));
            Transform2D transform = new Transform2D(1.0, 0.0, shx, esy, 0.0, 0.0, shape, 5);
            shape = transform.createTransformedShape((Component)((Object)plot), shape);
            edit.addEdit((LinkableEdit)transform);
            double sx = (double)plot.getWidth() / (w + 1.0);
            double sy = this.fixedRatio ? sx : (double)plot.getHeight() / (h + 1.0);
            double sz = this.fixedRatio ? sx : Math.min(sx, sy);
            edit.addEdit((LinkableEdit)new Scale(sx, sy, sz, shape, 5));
            edit.end();
            plot.postEdit((UndoableEdit)((Object)edit));
        }
        this.reset(plot, event);
    }

    public String toString() {
        return "Drag angled rectangle to Scale";
    }
}

