/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.interaction;

import hep.wired.edit.Rotate;
import hep.wired.feature.Rotateable3D;
import hep.wired.image.WiredBaseImage;
import hep.wired.interaction.DefaultInteractionHandler;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.undo.UndoableEdit;
import org.freehep.application.Application;

public class DragBallToRotate
extends DefaultInteractionHandler {
    private int xp;
    private int yp;
    private double ballRadius = 100.0;

    public DragBallToRotate() {
        super("Drag Ball to Rotate");
    }

    public Icon getIcon(int size) {
        return WiredBaseImage.getIcon("RotateBall%w", size);
    }

    public String getDescription() {
        return "Drag to rotate using virtual ball; Shift-drag to rotate over vertical axis; Ctrl-drag to rotate over horizontal axis.";
    }

    public boolean isSupportedBy(GraphicsPanel panel) {
        return new Rotate().isSupportedBy(panel) && panel.supports(Rotateable3D.class);
    }

    public void changeCursor(RecordPlot plot, InputEvent event) {
        plot.setCursor(WiredBaseImage.getBestCursor("RotateBallCursor%w", 32, 32));
    }

    public void reset(RecordPlot plot, InputEvent event) {
        Application.getApplication().setStatusMessage(this.getDescription());
    }

    public void mouseEntered(RecordPlot plot, MouseEvent event) {
        plot.requestFocusInWindow();
        this.changeCursor(plot, event);
    }

    public void mouseButton1DragStarted(RecordPlot plot, MouseEvent event) {
        this.xp = event.getX();
        this.yp = event.getY();
        plot.beginUpdate();
        plot.getGraphicsPanel().setFastMode(true);
    }

    public void mouseButton1Dragged(RecordPlot plot, MouseEvent event) {
        int dy;
        int xd = event.getX();
        int yd = event.getY();
        int dx = event.isControlDown() ? 0 : xd - this.xp;
        double drSquare = dx * dx + (dy = event.isShiftDown() ? 0 : -(yd - this.yp)) * dy;
        double dr = Math.sqrt(drSquare);
        if (dr == 0.0) {
            return;
        }
        double nx = (double)(-dy) / dr;
        double ny = (double)dx / dr;
        double nz = 0.0;
        double R = this.ballRadius;
        double cosTheta = R / Math.sqrt(R * R + drSquare);
        double theta = Math.acos(cosTheta);
        plot.postEdit((UndoableEdit)((Object)new Rotate(theta, nx, ny, nz)));
        this.xp = xd;
        this.yp = yd;
    }

    public void mouseButton1DragEnded(RecordPlot plot, MouseEvent event) {
        plot.getGraphicsPanel().setFastMode(false);
        plot.endUpdate();
        plot.repaint();
    }

    public String toString() {
        return "Drag to Rotate in 3D";
    }
}

