/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.interaction;

import hep.wired.edit.Scale;
import hep.wired.edit.Translate;
import hep.wired.edit.WiredCompoundEdit;
import hep.wired.feature.Translateable;
import hep.wired.image.WiredBaseImage;
import hep.wired.interaction.DefaultInteractionHandler;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.undo.UndoableEdit;
import org.freehep.application.Application;
import org.freehep.swing.undo.LinkableEdit;

public class DragRectangleToScale
extends DefaultInteractionHandler {
    private static final String name = "Combined Translate-Scale";
    private static final int cursorSize = 32;
    private static final double fixedScale = Math.sqrt(2.0);
    private boolean fixedRatio = true;
    private int xp;
    private int yp;
    private int xd;
    private int yd;
    private Rectangle rectangle;

    public DragRectangleToScale() {
        super("Drag Rectangle to Scale");
    }

    public Icon getIcon(int size) {
        return WiredBaseImage.getIcon("Rectangle%w", size);
    }

    public String getDescription() {
        return "Click center-zoom-in, Alt-Click to zoom-out-displace, Drag rectangle to zoom.";
    }

    public boolean isSupportedBy(GraphicsPanel panel) {
        return new Translate().isSupportedBy(panel) && new Scale().isSupportedBy(panel);
    }

    public void changeCursor(RecordPlot plot, InputEvent event) {
        if (event.getID() == 506) {
            plot.setCursor(WiredBaseImage.getBestCursor("RectangleScaleCursor%w", 32, 32));
        } else if (event.isAltDown()) {
            plot.setCursor(WiredBaseImage.getBestCursor("RectangleScaleMinusCursor%w", 32, 32));
        } else {
            plot.setCursor(WiredBaseImage.getBestCursor("RectangleScalePlusCursor%w", 32, 32));
        }
    }

    public void reset(RecordPlot plot, InputEvent event) {
        this.rectangle = null;
        plot.drawShape(null);
        Application.getApplication().setStatusMessage(this.getDescription());
    }

    public void mouseEntered(RecordPlot plot, MouseEvent event) {
        plot.requestFocusInWindow();
        this.changeCursor(plot, event);
    }

    public void mouseButton1DragStarted(RecordPlot plot, MouseEvent event) {
        this.xp = event.getX();
        this.yp = event.getY();
        this.changeCursor(plot, event);
        Application.getApplication().setStatusMessage("Drag rectangle to zoom, Shift removes ratio constraint.");
    }

    public void mouseButton1Dragged(RecordPlot plot, MouseEvent event) {
        this.xd = event.getX();
        this.yd = event.getY();
        this.defineRectangle(plot, event);
    }

    public void mouseButton1DragEnded(RecordPlot plot, MouseEvent event) {
        DragRectangleToScale.translateAndScale(plot, this.rectangle, this.fixedRatio);
        this.reset(plot, event);
    }

    public static void translateAndScale(RecordPlot plot, Rectangle rectangle, boolean fixedRatio) {
        int du = rectangle.x + rectangle.width / 2 - plot.getWidth() / 2;
        int dv = rectangle.y + rectangle.height / 2 - plot.getHeight() / 2;
        WiredCompoundEdit edit = new WiredCompoundEdit(name);
        Translateable translateable = (Translateable)plot.getGraphicsPanel().getFeature(Translateable.class);
        double[] t = translateable.getModelTranslation(new double[]{-du, dv, 0.0}, plot.getGraphicsPanel().getViewPort());
        Translate translate = new Translate(t[0], t[1], t[2], rectangle, 5);
        Shape shape = translate.createTransformedShape((Component)((Object)plot), rectangle);
        edit.addEdit((LinkableEdit)translate);
        double sx = plot.getWidth() / (rectangle.width + 1);
        double sy = fixedRatio ? sx : (double)(plot.getHeight() / (rectangle.height + 1));
        double sz = fixedRatio ? sx : Math.min(sx, sy);
        edit.addEdit((LinkableEdit)new Scale(sx, sy, sz, shape, 5));
        edit.end();
        plot.postEdit((UndoableEdit)((Object)edit));
    }

    public void mouseButton1Released(RecordPlot plot, MouseEvent event) {
        this.changeCursor(plot, event);
    }

    public boolean shiftKeyPressed(RecordPlot plot, KeyEvent event) {
        this.defineRectangle(plot, event);
        return true;
    }

    public boolean shiftKeyReleased(RecordPlot plot, KeyEvent event) {
        this.defineRectangle(plot, event);
        return true;
    }

    public boolean altKeyPressed(RecordPlot plot, KeyEvent event) {
        this.changeCursor(plot, event);
        return true;
    }

    public boolean altKeyReleased(RecordPlot plot, KeyEvent event) {
        this.changeCursor(plot, event);
        return true;
    }

    private void defineRectangle(RecordPlot plot, InputEvent event) {
        if (event instanceof KeyEvent && this.rectangle == null) {
            return;
        }
        int dx = this.xd - this.xp;
        int dy = this.yd - this.yp;
        if (!event.isShiftDown()) {
            double ratio = (double)plot.getHeight() / (double)plot.getWidth();
            if ((double)Math.abs(dy) < (double)Math.abs(dx) * ratio) {
                dy = (int)((double)(Math.abs(dx) * (dy < 0 ? -1 : 1)) * ratio);
            } else {
                dx = (int)((double)(Math.abs(dy) * (dx < 0 ? -1 : 1)) / ratio);
            }
            this.fixedRatio = true;
        } else {
            this.fixedRatio = false;
        }
        this.rectangle = new Rectangle(Math.min(this.xp, this.xp + dx), Math.min(this.yp, this.yp + dy), Math.abs(dx), Math.abs(dy));
        plot.drawShape(this.rectangle);
    }

    public void mouseButton1Clicked(RecordPlot plot, MouseEvent event) {
        int w2 = plot.getWidth() / 2;
        int h2 = plot.getHeight() / 2;
        int du = event.getX() - w2;
        int dv = event.getY() - h2;
        WiredCompoundEdit edit = new WiredCompoundEdit(name);
        if (event.isAltDown()) {
            Shape shape = new Rectangle(0, 0, 2 * w2, 2 * h2);
            Scale scale = new Scale(1.0 / fixedScale, 1.0 / fixedScale, 1.0 / fixedScale, shape, 5);
            shape = scale.createTransformedShape((Component)((Object)plot), shape);
            edit.addEdit((LinkableEdit)scale);
            Translateable translateable = (Translateable)plot.getGraphicsPanel().getFeature(Translateable.class);
            double[] t = translateable.getModelTranslation(new double[]{(double)du * fixedScale, (double)(-dv) * fixedScale, 0.0}, plot.getGraphicsPanel().getViewPort());
            edit.addEdit((LinkableEdit)new Translate(t[0], t[1], t[2], shape, 5));
        } else {
            int ws2 = (int)((double)w2 / fixedScale);
            int hs2 = (int)((double)h2 / fixedScale);
            Shape shape = new Rectangle(event.getX() - ws2, event.getY() - hs2, 2 * ws2, 2 * hs2);
            Translateable translateable = (Translateable)plot.getGraphicsPanel().getFeature(Translateable.class);
            double[] t = translateable.getModelTranslation(new double[]{-du, dv, 0.0}, plot.getGraphicsPanel().getViewPort());
            Translate translate = new Translate(t[0], t[1], t[2], shape, 5);
            shape = translate.createTransformedShape((Component)((Object)plot), shape);
            edit.addEdit((LinkableEdit)translate);
            edit.addEdit((LinkableEdit)new Scale(fixedScale, fixedScale, fixedScale, shape, 5));
        }
        edit.end();
        plot.postEdit((UndoableEdit)((Object)edit));
    }

    public String toString() {
        return "Drag rectangle to Scale";
    }
}

