/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.interaction;

import hep.wired.edit.Rotate;
import hep.wired.image.WiredBaseImage;
import hep.wired.interaction.DefaultInteractionHandler;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.undo.UndoableEdit;
import org.freehep.application.Application;

public class DragToRotate
extends DefaultInteractionHandler {
    private int xp;
    private int yp;

    public DragToRotate() {
        super("Drag to Rotate in Z");
    }

    public Icon getIcon(int size) {
        return WiredBaseImage.getIcon("Rotate%w", size);
    }

    public String getDescription() {
        return "Drag around center to rotate in the Z plane.";
    }

    public boolean isSupportedBy(GraphicsPanel panel) {
        return new Rotate().isSupportedBy(panel);
    }

    public void changeCursor(RecordPlot plot, InputEvent event) {
        plot.setCursor(WiredBaseImage.getBestCursor("RotateCursor%w", 32, 32));
    }

    public void reset(RecordPlot plot, InputEvent event) {
        Application.getApplication().setStatusMessage(this.getDescription());
    }

    public void mouseEntered(RecordPlot plot, MouseEvent event) {
        plot.requestFocusInWindow();
        this.changeCursor(plot, event);
    }

    public void mouseButton1DragStarted(RecordPlot plot, MouseEvent event) {
        this.xp = event.getX();
        this.yp = event.getY();
        plot.beginUpdate();
        plot.getGraphicsPanel().setFastMode(true);
    }

    public void mouseButton1Dragged(RecordPlot plot, MouseEvent event) {
        int xd = event.getX();
        int yd = event.getY();
        int x1 = xd - plot.getWidth() / 2;
        int y1 = yd - plot.getHeight() / 2;
        int x2 = this.xp - plot.getWidth() / 2;
        int y2 = this.yp - plot.getHeight() / 2;
        double angle = Math.atan2(x1, y1) - Math.atan2(x2, y2);
        plot.postEdit((UndoableEdit)((Object)new Rotate(angle, 0.0, 0.0, 1.0)));
        this.xp = xd;
        this.yp = yd;
    }

    public void mouseButton1DragEnded(RecordPlot plot, MouseEvent event) {
        plot.getGraphicsPanel().setFastMode(false);
        plot.endUpdate();
        plot.repaint();
    }

    public String toString() {
        return "Drag to Rotate in Z-Plane";
    }
}

