/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.interaction;

import hep.wired.edit.Scale;
import hep.wired.image.WiredBaseImage;
import hep.wired.interaction.DefaultInteractionHandler;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.undo.UndoableEdit;
import org.freehep.application.Application;

public class DragToScale
extends DefaultInteractionHandler {
    private double dpsq;

    public DragToScale() {
        super("Drag to Scale");
    }

    public boolean isSupportedBy(GraphicsPanel panel) {
        return new Scale().isSupportedBy(panel);
    }

    public Icon getIcon(int size) {
        return WiredBaseImage.getIcon("Scale%w", size);
    }

    public String getDescription() {
        return "Click to zoom in, Alt-Click to zoom out, Drag inward or outward to instant zoom.";
    }

    public void changeCursor(RecordPlot plot, InputEvent event) {
        if (event.getID() == 506) {
            plot.setCursor(WiredBaseImage.getBestCursor("ScaleCursor%w", 32, 32));
        } else if (event.isAltDown()) {
            plot.setCursor(WiredBaseImage.getBestCursor("ScaleMinusCursor%w", 32, 32));
        } else {
            plot.setCursor(WiredBaseImage.getBestCursor("ScalePlusCursor%w", 32, 32));
        }
    }

    public void reset(RecordPlot plot, InputEvent event) {
        plot.getGraphicsPanel().setFastMode(false);
        plot.drawShape(null);
        plot.repaint();
        Application.getApplication().setStatusMessage(this.getDescription());
    }

    public void mouseEntered(RecordPlot plot, MouseEvent event) {
        plot.requestFocusInWindow();
        this.changeCursor(plot, event);
    }

    public void mouseButton1DragStarted(RecordPlot plot, MouseEvent event) {
        this.dpsq = Point2D.distanceSq((double)event.getComponent().getWidth() / 2.0, (double)event.getComponent().getHeight() / 2.0, event.getX(), event.getY());
        this.changeCursor(plot, event);
        plot.beginUpdate();
        plot.getGraphicsPanel().setFastMode(true);
    }

    public void mouseButton1Dragged(RecordPlot plot, MouseEvent event) {
        double ddsq = Point2D.distanceSq((double)event.getComponent().getWidth() / 2.0, (double)event.getComponent().getHeight() / 2.0, event.getX(), event.getY());
        double s = Math.sqrt(ddsq / this.dpsq);
        plot.postEdit((UndoableEdit)((Object)new Scale(s, s, s)));
        this.dpsq = ddsq;
        this.defineShape(plot, event);
    }

    public void mouseButton1DragEnded(RecordPlot plot, MouseEvent event) {
        plot.endUpdate();
        this.reset(plot, event);
    }

    public void mouseButton1Released(RecordPlot plot, MouseEvent event) {
        this.changeCursor(plot, event);
    }

    public boolean altKeyPressed(RecordPlot plot, KeyEvent event) {
        this.changeCursor(plot, event);
        return true;
    }

    public boolean altKeyReleased(RecordPlot plot, KeyEvent event) {
        this.changeCursor(plot, event);
        return true;
    }

    public void mouseButton1Clicked(RecordPlot plot, MouseEvent event) {
        double w = event.getComponent().getWidth();
        double h = event.getComponent().getHeight();
        plot.beginUpdate();
        if (event.isAltDown()) {
            Rectangle2D.Double shape = new Rectangle2D.Double(0.0, 0.0, w, h);
            plot.postEdit((UndoableEdit)((Object)new Scale(1.0 / fixedScale, 1.0 / fixedScale, 1.0 / fixedScale, shape, 5)));
        } else {
            Rectangle2D.Double shape = new Rectangle2D.Double((w - w / fixedScale) / 2.0, (h - h / fixedScale) / 2.0, w / fixedScale, h / fixedScale);
            plot.postEdit((UndoableEdit)((Object)new Scale(fixedScale, fixedScale, fixedScale, shape, 5)));
        }
        plot.endUpdate();
        this.reset(plot, event);
    }

    private void defineShape(RecordPlot plot, MouseEvent event) {
        double x = (double)event.getComponent().getWidth() / 2.0;
        double y = (double)event.getComponent().getHeight() / 2.0;
        double d = Point2D.distance(event.getX(), event.getY(), x, y);
        plot.drawShape(new Ellipse2D.Double(x - d, y - d, d * 2.0, d * 2.0));
    }

    public String toString() {
        return "Drag to Scale";
    }
}

