/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.interaction;

import hep.wired.edit.Translate;
import hep.wired.feature.Translateable;
import hep.wired.image.WiredBaseImage;
import hep.wired.interaction.DefaultInteractionHandler;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.RecordPlot;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.undo.UndoableEdit;
import org.freehep.application.Application;

public class DragToTranslate
extends DefaultInteractionHandler {
    private int xp;
    private int yp;
    private static final int cursorSize = 32;

    public DragToTranslate() {
        super("Drag to Translate");
    }

    public Icon getIcon(int size) {
        return WiredBaseImage.getIcon("Translate%w", size);
    }

    public String getDescription() {
        return "Click to center point, Alt-Click to move center to point, Drag to instant translate.";
    }

    public boolean isSupportedBy(GraphicsPanel panel) {
        return new Translate().isSupportedBy(panel);
    }

    public void reset(RecordPlot plot, InputEvent event) {
        Application.getApplication().setStatusMessage(this.getDescription());
    }

    public void changeCursor(RecordPlot plot, InputEvent event) {
        plot.setCursor(WiredBaseImage.getBestCursor("TranslateCursor%w", 32, 32));
    }

    public void mouseEntered(RecordPlot plot, MouseEvent event) {
        plot.requestFocusInWindow();
        this.changeCursor(plot, event);
    }

    public void mouseButton1DragStarted(RecordPlot plot, MouseEvent event) {
        this.xp = event.getX();
        this.yp = event.getY();
        plot.beginUpdate();
        plot.getGraphicsPanel().setFastMode(true);
    }

    public void mouseButton1DragEnded(RecordPlot plot, MouseEvent event) {
        plot.getGraphicsPanel().setFastMode(false);
        plot.endUpdate();
        plot.repaint();
    }

    public void mouseButton1Dragged(RecordPlot plot, MouseEvent event) {
        int xd = event.getX();
        int yd = event.getY();
        Translateable translateable = (Translateable)plot.getGraphicsPanel().getFeature(Translateable.class);
        double[] t = translateable.getModelTranslation(new double[]{xd - this.xp, -yd + this.yp, 0.0}, plot.getGraphicsPanel().getViewPort());
        plot.postEdit((UndoableEdit)((Object)new Translate(t[0], t[1], t[2])));
        this.xp = xd;
        this.yp = yd;
    }

    public void mouseButton1Clicked(RecordPlot plot, MouseEvent event) {
        plot.beginUpdate();
        int w2 = plot.getWidth() / 2;
        int h2 = plot.getHeight() / 2;
        int dx = event.getX() - w2;
        int dy = event.getY() - h2;
        Translateable translateable = (Translateable)plot.getGraphicsPanel().getFeature(Translateable.class);
        if (event.isAltDown()) {
            Rectangle2D.Double shape = new Rectangle2D.Double(w2 - 32, h2 - 32, 64.0, 64.0);
            double[] t = translateable.getModelTranslation(new double[]{dx, -dy, 0.0}, plot.getGraphicsPanel().getViewPort());
            plot.postEdit((UndoableEdit)((Object)new Translate(t[0], t[1], t[2], shape, 5)));
        } else {
            Rectangle2D.Double shape = new Rectangle2D.Double(event.getX() - 32, event.getY() - 32, 64.0, 64.0);
            double[] t = translateable.getModelTranslation(new double[]{-dx, dy, 0.0}, plot.getGraphicsPanel().getViewPort());
            plot.postEdit((UndoableEdit)((Object)new Translate(t[0], t[1], t[2], shape, 5)));
        }
        plot.endUpdate();
    }

    public String toString() {
        return "Drag to Translate";
    }
}

