/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.plot;

import hep.wired.edit.GraphicsPanelEdit;
import hep.wired.edit.NoOperation;
import hep.wired.edit.WiredCompoundEdit;
import hep.wired.edit.WiredEdit;
import hep.wired.services.GraphicsPanel;
import hep.wired.services.InteractionHandler;
import hep.wired.services.RecordPlot;
import hep.wired.util.NullEvent;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.freehep.application.Application;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.swing.undo.AnimatedEditSupport;
import org.freehep.swing.undo.DoableEdit;
import org.freehep.xml.io.XMLIO;
import org.freehep.xml.io.XMLIOManager;
import org.jdom.Content;
import org.jdom.Element;

public class WiredPlot
extends JPanel
implements RecordPlot,
HasPopupItems,
XMLIO {
    private static Logger logger = Logger.getLogger(WiredPlot.class.getPackage().getName());
    private long t0;
    private String name;
    private GraphicsPanel graphicsPanel;
    private UndoableEditSupport undoSupport;
    private transient boolean selected;
    private InteractionHandler handler;
    private transient boolean pressed;
    private transient boolean dragged;
    private transient boolean clicked;
    private transient MouseEvent pressEvent;
    private transient MouseListener mouseListener;
    private transient MouseMotionListener mouseMotionListener;
    private transient MouseWheelListener mouseWheelListener;
    private transient KeyListener keyListener;
    private Color color = Color.white;
    private double lineWidth = 1.0;
    private Color frameColor = Color.black;
    private double frameWidth = 3.0;
    private Shape shape;

    private WiredPlot() {
        this(null, null, false, null);
    }

    public WiredPlot(GraphicsPanel graphicsPanel) {
        this("Plot", graphicsPanel);
    }

    public WiredPlot(String name, GraphicsPanel graphicsPanel) {
        this(name, graphicsPanel, true);
    }

    public WiredPlot(String name, GraphicsPanel graphicsPanel, boolean supportUndo) {
        this(name, graphicsPanel, supportUndo, null);
    }

    private WiredPlot(String name, GraphicsPanel graphicsPanel, boolean supportUndo, InteractionHandler interactionHandler) {
        super(false);
        this.name = name;
        this.selected = false;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        if (graphicsPanel != null) {
            this.setGraphicsPanel(graphicsPanel);
        }
        if (supportUndo) {
            this.addUndoSupport();
        }
        if (interactionHandler != null) {
            this.setInteractionHandler(interactionHandler);
        }
    }

    public RecordPlot copy(String name, Object record, boolean supportUndo) {
        WiredPlot copy = new WiredPlot(name, this.graphicsPanel.copy(), supportUndo, null);
        copy.setInteractionHandler(this.getInteractionHandler());
        copy.setRecord(record);
        copy.color = this.color;
        copy.lineWidth = this.lineWidth;
        copy.frameColor = this.frameColor;
        copy.frameWidth = this.frameWidth;
        copy.shape = this.shape;
        return copy;
    }

    private void setGraphicsPanel(GraphicsPanel newPanel) {
        if (this.graphicsPanel != null) {
            this.remove((Component)((Object)this.graphicsPanel));
        }
        this.graphicsPanel = newPanel;
        this.add((Component)((Object)this.graphicsPanel), "Center");
    }

    private void addUndoSupport() {
        this.undoSupport = new AnimatedEditSupport((Object)this);
    }

    public UndoableEditSupport getUndoableEditSupport() {
        return this.undoSupport;
    }

    public String getName() {
        return this.name;
    }

    public boolean requestFocusInWindow() {
        return ((Component)((Object)this.graphicsPanel)).requestFocusInWindow();
    }

    public GraphicsPanel getGraphicsPanel() {
        return this.graphicsPanel;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.graphicsPanel.setSelected(this, selected);
        if (this.handler != null) {
            this.handler.setSelected(this, selected);
        }
    }

    public void repaint() {
        super.repaint();
        if (this.graphicsPanel != null) {
            ((Component)((Object)this.graphicsPanel)).repaint();
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        ((Component)((Object)this.graphicsPanel)).setBounds(x, y, width, height);
        if (this.handler != null) {
            this.handler.setSize(this, width, height);
        }
        super.setBounds(x, y, width, height);
    }

    public String toString() {
        return this.getName() == null ? "WiredPlot@" + this.hashCode() : "WiredPlot: " + this.getName();
    }

    public boolean supports(UndoableEdit edit) {
        if (edit instanceof NoOperation) {
            return true;
        }
        if (edit instanceof GraphicsPanelEdit) {
            GraphicsPanelEdit graphicsPanelEdit = (GraphicsPanelEdit)((Object)edit);
            return graphicsPanelEdit.isSupportedBy(this.getGraphicsPanel());
        }
        return false;
    }

    public void postEdit(UndoableEdit edit) {
        if (edit instanceof DoableEdit) {
            this.postEdit((DoableEdit)edit);
            return;
        }
        logger.warning("Edit ignored: " + edit);
    }

    public void postEdit(DoableEdit edit) {
        if (edit instanceof WiredEdit) {
            this.postEdit((WiredEdit)edit);
            return;
        }
        if (edit instanceof WiredCompoundEdit) {
            this.postEdit((WiredCompoundEdit)edit);
            return;
        }
        logger.warning("Edit should be Wired(Compound)Edit...: " + edit);
        edit.redo();
        if (edit.isSignificant() && this.undoSupport != null) {
            this.undoSupport.postEdit((UndoableEdit)edit);
        }
    }

    public void postEdit(WiredEdit edit) {
        WiredEdit wiredEdit = edit.copy(this);
        wiredEdit.redo();
        if (wiredEdit.isSignificant() && this.undoSupport != null) {
            this.undoSupport.postEdit((UndoableEdit)((Object)wiredEdit));
        }
    }

    public void postEdit(WiredCompoundEdit edit) {
        WiredCompoundEdit wiredEdit = edit.copy(this);
        wiredEdit.redo();
        if (wiredEdit.isSignificant() && this.undoSupport != null) {
            this.undoSupport.postEdit((UndoableEdit)((Object)wiredEdit));
        }
    }

    public void beginUpdate() {
        if (this.undoSupport != null) {
            this.undoSupport.beginUpdate();
        }
    }

    public void endUpdate() {
        if (this.undoSupport != null) {
            this.undoSupport.endUpdate();
        }
    }

    public boolean supports(InteractionHandler interactionHandler) {
        return interactionHandler.isSupportedBy(this.getGraphicsPanel());
    }

    public void setInteractionHandler(InteractionHandler interactionHandler) {
        if (this.selected) {
            if (this.handler != null) {
                this.handler.setSelected(this, false);
            }
            interactionHandler.setSelected(this, true);
        }
        Component panel = (Component)((Object)this.graphicsPanel);
        if (this.mouseListener != null) {
            panel.removeMouseListener(this.mouseListener);
        }
        if (this.mouseMotionListener != null) {
            panel.removeMouseMotionListener(this.mouseMotionListener);
        }
        if (this.mouseWheelListener != null) {
            panel.removeMouseWheelListener(this.mouseWheelListener);
        }
        if (this.keyListener != null) {
            panel.removeKeyListener(this.keyListener);
        }
        this.handler = interactionHandler;
        this.drawShape(null);
        this.repaint();
        if (this.handler != null) {
            this.handler.setSize(this, this.getWidth(), this.getHeight());
            this.handler.reset(this, new NullEvent(this));
            this.handler.changeCursor(this, new NullEvent(this));
            this.mouseListener = new MouseListener(){

                public void mousePressed(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        event.getComponent().requestFocusInWindow();
                        WiredPlot.this.pressed = true;
                        WiredPlot.this.pressEvent = event;
                        WiredPlot.this.clicked = true;
                        WiredPlot.this.dragged = false;
                        WiredPlot.this.handler.mouseButton1Pressed(WiredPlot.this, event);
                    }
                }

                public void mouseReleased(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        if (WiredPlot.this.dragged) {
                            WiredPlot.this.handler.mouseButton1DragEnded(WiredPlot.this, event);
                            WiredPlot.this.dragged = false;
                        }
                        WiredPlot.this.handler.mouseButton1Released(WiredPlot.this, event);
                        WiredPlot.this.pressed = false;
                        WiredPlot.this.pressEvent = null;
                    }
                }

                public void mouseClicked(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        if (WiredPlot.this.clicked) {
                            WiredPlot.this.handler.mouseButton1Clicked(WiredPlot.this, event);
                            WiredPlot.this.clicked = false;
                        }
                        WiredPlot.this.pressed = false;
                        WiredPlot.this.pressEvent = null;
                        WiredPlot.this.dragged = false;
                    }
                }

                public void mouseEntered(MouseEvent event) {
                    event.getComponent().requestFocusInWindow();
                    WiredPlot.this.handler.mouseEntered(WiredPlot.this, event);
                }

                public void mouseExited(MouseEvent event) {
                    WiredPlot.this.handler.mouseExited(WiredPlot.this, event);
                }
            };
            panel.addMouseListener(this.mouseListener);
            this.mouseMotionListener = new MouseMotionListener(){

                public void mouseDragged(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event) && WiredPlot.this.pressed) {
                        if (WiredPlot.this.pressEvent != null) {
                            WiredPlot.this.dragged = true;
                            WiredPlot.this.clicked = false;
                            WiredPlot.this.handler.mouseButton1DragStarted(WiredPlot.this, WiredPlot.this.pressEvent);
                            WiredPlot.this.pressEvent = null;
                        }
                        WiredPlot.this.handler.mouseButton1Dragged(WiredPlot.this, event);
                    }
                }

                public void mouseMoved(MouseEvent event) {
                    WiredPlot.this.handler.mouseMoved(WiredPlot.this, event);
                }
            };
            panel.addMouseMotionListener(this.mouseMotionListener);
            this.mouseWheelListener = new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent event) {
                    WiredPlot.this.handler.mouseWheelMoved(WiredPlot.this, event);
                }
            };
            panel.addMouseWheelListener(this.mouseWheelListener);
            this.keyListener = new KeyListener(){
                private boolean altKeyDown;
                private boolean ctrlKeyDown;
                private boolean shiftKeyDown;
                private boolean escKeyDown;

                public void keyPressed(KeyEvent event) {
                    boolean consume = false;
                    switch (event.getKeyCode()) {
                        case 18: {
                            if (this.altKeyDown) break;
                            this.altKeyDown = true;
                            consume = WiredPlot.this.handler.altKeyPressed(WiredPlot.this, event);
                            break;
                        }
                        case 17: {
                            if (this.ctrlKeyDown) break;
                            this.ctrlKeyDown = true;
                            consume = WiredPlot.this.handler.ctrlKeyPressed(WiredPlot.this, event);
                            break;
                        }
                        case 16: {
                            if (this.shiftKeyDown) break;
                            this.shiftKeyDown = true;
                            consume = WiredPlot.this.handler.shiftKeyPressed(WiredPlot.this, event);
                            break;
                        }
                        case 27: {
                            if (this.escKeyDown) break;
                            this.escKeyDown = true;
                            WiredPlot.this.pressed = false;
                            WiredPlot.this.dragged = false;
                            WiredPlot.this.handler.reset(WiredPlot.this, event);
                            consume = WiredPlot.this.handler.escKeyPressed(WiredPlot.this, event);
                            break;
                        }
                        default: {
                            consume = WiredPlot.this.handler.otherKeyPressed(WiredPlot.this, event);
                        }
                    }
                    if (consume) {
                        event.consume();
                    }
                }

                public void keyReleased(KeyEvent event) {
                    boolean consume = false;
                    switch (event.getKeyCode()) {
                        case 18: {
                            if (!this.altKeyDown) break;
                            this.altKeyDown = false;
                            consume = WiredPlot.this.handler.altKeyReleased(WiredPlot.this, event);
                            break;
                        }
                        case 17: {
                            if (!this.ctrlKeyDown) break;
                            this.ctrlKeyDown = false;
                            consume = WiredPlot.this.handler.ctrlKeyReleased(WiredPlot.this, event);
                            break;
                        }
                        case 16: {
                            if (!this.shiftKeyDown) break;
                            this.shiftKeyDown = false;
                            consume = WiredPlot.this.handler.shiftKeyReleased(WiredPlot.this, event);
                            break;
                        }
                        case 27: {
                            if (!this.escKeyDown) break;
                            this.escKeyDown = false;
                            consume = WiredPlot.this.handler.escKeyReleased(WiredPlot.this, event);
                            break;
                        }
                        default: {
                            consume = WiredPlot.this.handler.otherKeyReleased(WiredPlot.this, event);
                        }
                    }
                    if (consume) {
                        event.consume();
                    }
                }

                public void keyTyped(KeyEvent event) {
                    boolean consume = WiredPlot.this.handler.keyTyped(WiredPlot.this, event);
                    if (consume) {
                        event.consume();
                    }
                }
            };
            panel.addKeyListener(this.keyListener);
        }
        panel.requestFocusInWindow();
    }

    public void drawShape(Shape shape) {
        this.shape = shape;
        super.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.shape != null) {
            VectorGraphics graphics = VectorGraphics.create((Graphics)g);
            BasicStroke cs = (BasicStroke)graphics.getStroke();
            graphics.setStroke((Stroke)new BasicStroke(cs.getLineWidth(), cs.getEndCap(), cs.getLineJoin(), 1.0f, cs.getDashArray(), cs.getDashPhase()));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(this.frameColor);
            graphics.setLineWidth(this.frameWidth);
            graphics.draw(this.shape);
            graphics.setLineWidth(this.lineWidth);
            graphics.setColor(this.color);
            graphics.draw(this.shape);
        }
    }

    public InteractionHandler getInteractionHandler() {
        return this.handler;
    }

    public void setRecord(Object record) {
        this.graphicsPanel.setRecord(record);
        if (this.handler != null) {
            this.handler.setRecord(this, record);
        }
        this.repaint();
    }

    public Object getRecord() {
        return this.graphicsPanel.getRecord();
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        Application.getApplication().getXMLMenuBuilder().mergePopupMenu("wiredBasePopupMenu", menu);
        menu = this.graphicsPanel.modifyPopupMenu(menu, this);
        return menu;
    }

    public void save(XMLIOManager xmlioManager, Element nodeEl) {
        if (this.name != null) {
            nodeEl.setAttribute("name", this.name);
        }
        nodeEl.addContent((Content)xmlioManager.save((Object)this.graphicsPanel));
        if (this.handler != null) {
            nodeEl.addContent((Content)xmlioManager.save((Object)this.handler));
        }
        nodeEl.setAttribute("undo", this.undoSupport != null ? "true" : "false");
    }

    public void restore(XMLIOManager xmlioManager, Element nodeEl) {
        this.name = nodeEl.getAttributeValue("name");
        Iterator i = nodeEl.getChildren().iterator();
        this.setGraphicsPanel((GraphicsPanel)xmlioManager.restore((Element)i.next()));
        if (i.hasNext()) {
            this.setInteractionHandler((InteractionHandler)xmlioManager.restore((Element)i.next()));
        }
        if (nodeEl.getAttributeValue("undo", "").equals("true")) {
            this.addUndoSupport();
        }
    }
}

