/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.plot;

import hep.wired.edit.FitToWindow;
import hep.wired.edit.Reset;
import hep.wired.interaction.DragAngledRectangleToScale;
import hep.wired.interaction.DragBallToRotate;
import hep.wired.interaction.DragRectangleToScale;
import hep.wired.interaction.DragToRotate;
import hep.wired.interaction.DragToScale;
import hep.wired.interaction.DragToTranslate;
import hep.wired.services.RecordPlot;
import hep.wired.util.WiredUndoManager;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.freehep.application.Application;
import org.freehep.application.PrintHelper;
import org.freehep.application.studio.Studio;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.export.VectorGraphicsTransferable;

public class WiredPlotCommandHandler
extends CommandProcessor
implements UndoableEditListener {
    private RecordPlot plot;
    private WiredUndoManager undoManager = new WiredUndoManager();

    public WiredPlotCommandHandler(RecordPlot plot) {
        this.plot = plot;
    }

    public void enableRedo(CommandState state) {
        state.setEnabled(this.undoManager.canRedo());
        state.setText("Redo " + this.undoManager.getRedoString());
        state.setToolTipText(this.undoManager.getRedoPresentationName());
        this.setChanged();
    }

    public void onRedo() {
        this.undoManager.redo();
        this.setChanged();
    }

    public void enableUndo(CommandState state) {
        state.setEnabled(this.undoManager.canUndo());
        state.setText("Undo " + this.undoManager.getUndoString());
        state.setToolTipText(this.undoManager.getUndoPresentationName());
        this.setChanged();
    }

    public void onUndo() {
        this.undoManager.undo();
        this.setChanged();
    }

    public void onPrintSetup() {
        Studio studio = (Studio)Application.getApplication();
        PrintHelper printHelper = new PrintHelper((Component)((Object)this.plot), studio);
        printHelper.showOptionsDialog((Component)studio);
    }

    public void enablePrint(CommandState state) {
        state.setEnabled(this.plot.getRecord() != null);
        this.setChanged();
    }

    public void onPrint() throws Exception {
        Studio studio = (Studio)Application.getApplication();
        PrintHelper printHelper = new PrintHelper((Component)((Object)this.plot), studio);
        printHelper.print();
    }

    public void enablePrintPreview(CommandState state) {
        state.setEnabled(this.plot.getRecord() != null);
        this.setChanged();
    }

    public void onPrintPreview() throws Exception {
        Studio studio = (Studio)Application.getApplication();
        PrintHelper printHelper = new PrintHelper((Component)((Object)this.plot), studio);
        printHelper.printPreview((Component)studio);
    }

    public void enableCopy(CommandState state) {
        state.setEnabled(this.plot.getRecord() != null);
        this.setChanged();
    }

    public void onCopy() {
        Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        VectorGraphicsTransferable transferable = new VectorGraphicsTransferable((Component)((Object)this.plot));
        clipBoard.setContents((Transferable)transferable, (ClipboardOwner)transferable);
    }

    public void undoableEditHappened(UndoableEditEvent edit) {
        this.undoManager.addEdit(edit.getEdit());
        this.setChanged();
    }

    public void enableDragToScale(BooleanCommandState state) {
        state.setEnabled(this.plot.supports(new DragToScale()));
        state.setSelected(this.plot.getInteractionHandler() instanceof DragToScale);
        this.setChanged();
    }

    public void onDragToScale(boolean on) {
        if (on) {
            this.plot.setInteractionHandler(new DragToScale());
        }
        this.setChanged();
    }

    public void enableDragRectangleToScale(BooleanCommandState state) {
        state.setEnabled(this.plot.supports(new DragRectangleToScale()));
        state.setSelected(this.plot.getInteractionHandler() instanceof DragRectangleToScale);
        this.setChanged();
    }

    public void onDragRectangleToScale(boolean on) {
        if (on) {
            this.plot.setInteractionHandler(new DragRectangleToScale());
        }
        this.setChanged();
    }

    public void enableDragAngledRectangleToScale(BooleanCommandState state) {
        state.setEnabled(this.plot.supports(new DragAngledRectangleToScale()));
        state.setSelected(this.plot.getInteractionHandler() instanceof DragAngledRectangleToScale);
        this.setChanged();
    }

    public void onDragAngledRectangleToScale(boolean on) {
        if (on) {
            this.plot.setInteractionHandler(new DragAngledRectangleToScale());
        }
        this.setChanged();
    }

    public void enableDragToTranslate(BooleanCommandState state) {
        state.setEnabled(this.plot.supports(new DragToTranslate()));
        state.setSelected(this.plot.getInteractionHandler() instanceof DragToTranslate);
        this.setChanged();
    }

    public void onDragToTranslate(boolean on) {
        if (on) {
            this.plot.setInteractionHandler(new DragToTranslate());
        }
        this.setChanged();
    }

    public void enableDragToRotate(BooleanCommandState state) {
        state.setEnabled(this.plot.supports(new DragToRotate()));
        state.setSelected(this.plot.getInteractionHandler() instanceof DragToRotate);
        this.setChanged();
    }

    public void onDragToRotate(boolean on) {
        if (on) {
            this.plot.setInteractionHandler(new DragToRotate());
        }
        this.setChanged();
    }

    public void enableDragBallToRotate(BooleanCommandState state) {
        state.setEnabled(this.plot.supports(new DragBallToRotate()));
        state.setSelected(this.plot.getInteractionHandler() instanceof DragBallToRotate);
        this.setChanged();
    }

    public void onDragBallToRotate(boolean on) {
        if (on) {
            this.plot.setInteractionHandler(new DragBallToRotate());
        }
        this.setChanged();
    }

    public void enableReset(CommandState state) {
        state.setEnabled(this.plot.supports((UndoableEdit)((Object)new Reset())));
        this.setChanged();
    }

    public void onReset() {
        this.plot.postEdit((UndoableEdit)((Object)new Reset()));
    }

    public void enableFitToWindow(CommandState state) {
        state.setEnabled(this.plot.supports((UndoableEdit)((Object)new FitToWindow())));
        this.setChanged();
    }

    public void onFitToWindow() {
        this.plot.postEdit((UndoableEdit)((Object)new FitToWindow()));
    }
}

