/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.plugin;

import hep.wired.plot.WiredPlot;
import hep.wired.plugin.WiredPage;
import hep.wired.plugin.WiredXMLIOFactory;
import hep.wired.services.InteractionHandler;
import hep.wired.services.ViewPort;
import hep.wired.util.Matrix2D;
import hep.wired.util.Matrix3D;
import hep.wired.util.WiredRegistry;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.xml.io.XMLIORegistry;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WiredBase
extends Plugin {
    protected void init() throws SAXException, IOException {
        Studio application = this.getApplication();
        WiredRegistry.add((Object)this);
        this.addXMLIOFactories(null);
        XMLMenuBuilder builder = application.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("WiredBase.menus");
        try {
            builder.build(xml);
        }
        catch (SAXParseException e) {
            System.out.println(e);
            System.out.println("at line: " + e.getLineNumber() + " column: " + e.getColumnNumber());
            throw e;
        }
        application.addToolBar(builder.getToolBar("actionToolBar"), "Action Toolbar");
        application.addToolBar(builder.getToolBar("interactionToolBar"), "Interaction Toolbar");
        application.addToolBar(builder.getToolBar("qualityToolBar"), "Quality Toolbar");
    }

    private void addXMLIOFactories(XMLIORegistry registry) {
        this.addXMLIOFactory(registry, WiredPage.class);
        this.addXMLIOFactory(registry, WiredPlot.class);
        this.addXMLIOFactory(registry, Matrix3D.class);
        this.addXMLIOFactory(registry, Matrix2D.class);
        this.addXMLIOFactoryForService(registry, InteractionHandler.class);
        this.addXMLIOFactoryForService(registry, ViewPort.class);
    }

    private void addXMLIOFactory(XMLIORegistry registry, Class cls) {
        if (registry == null || registry.getXMLIOFactory(cls) == null) {
            WiredRegistry.add(new WiredXMLIOFactory(cls));
        }
    }

    private void addXMLIOFactoryForService(XMLIORegistry registry, Class service) {
        Set allClasses = WiredRegistry.allClasses(service);
        Iterator i = allClasses.iterator();
        while (i.hasNext()) {
            this.addXMLIOFactory(registry, (Class)i.next());
        }
    }
}

