/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.plugin;

import hep.wired.services.RecordPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEditSupport;
import org.freehep.application.Application;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.studio.Studio;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.io.XMLIO;
import org.freehep.xml.io.XMLIOManager;
import org.jdom.Content;
import org.jdom.Element;

public class WiredPage
extends JPanel
implements ManagedPage,
XMLIO {
    private static Logger logger = Logger.getLogger(WiredPage.class.getPackage().getName());
    private String name;
    private RecordPlot plot;
    private CommandProcessor processor;

    private WiredPage() {
        this("NotInitialized", null, null);
    }

    public WiredPage(String name, RecordPlot plot, CommandProcessor processor) {
        this.name = name;
        this.plot = plot;
        this.processor = processor;
        this.setLayout(new BorderLayout());
        if (plot != null) {
            this.init(plot);
        }
    }

    private void init(RecordPlot plot) {
        UndoableEditSupport undoSupport;
        this.add((Component)((Object)plot), "Center");
        if (this.processor != null && this.processor instanceof UndoableEditListener && (undoSupport = plot.getUndoableEditSupport()) != null) {
            undoSupport.addUndoableEditListener((UndoableEditListener)this.processor);
        }
    }

    public String getName() {
        return this.name;
    }

    public RecordPlot getRecordPlot() {
        return this.plot;
    }

    public void setChanged() {
        if (this.processor != null) {
            this.processor.setChanged();
        }
    }

    public boolean close() {
        return true;
    }

    public void pageClosed() {
    }

    public void pageIconized() {
    }

    public void pageDeiconized() {
    }

    public void pageSelected() {
        if (this.processor != null) {
            ((Studio)Application.getApplication()).getCommandTargetManager().add((CommandGroup)this.processor);
        }
        this.plot.setSelected(true);
    }

    public void pageDeselected() {
        if (this.processor != null) {
            ((Studio)Application.getApplication()).getCommandTargetManager().remove((CommandGroup)this.processor);
        }
        this.plot.setSelected(false);
    }

    public void setPageContext(PageContext context) {
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        return this.plot instanceof HasPopupItems ? ((HasPopupItems)this.plot).modifyPopupMenu(menu, source, p) : menu;
    }

    public void save(XMLIOManager xmlioManager, Element nodeEl) {
        nodeEl.setAttribute("name", this.name);
        nodeEl.addContent((Content)xmlioManager.save((Object)this.plot));
    }

    public void restore(XMLIOManager xmlioManager, Element nodeEl) {
        this.name = nodeEl.getAttributeValue("name");
        Iterator i = nodeEl.getChildren().iterator();
        this.plot = (RecordPlot)xmlioManager.restore((Element)i.next());
        this.init(this.plot);
    }
}

