/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.util;

import hep.wired.util.TristateCheckBox;
import hep.wired.util.TristateTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class DefaultTristateTreeNode
extends DefaultMutableTreeNode
implements TristateTreeNode {
    protected boolean included;
    protected boolean selected;
    protected boolean valid;
    protected TristateCheckBox.State state;

    public DefaultTristateTreeNode(Object data) {
        this(data, true);
    }

    public DefaultTristateTreeNode(Object data, boolean selected) {
        this(data, selected, true);
    }

    public DefaultTristateTreeNode(Object data, boolean selected, boolean included) {
        super(data);
        this.selected = selected;
        this.included = included;
        this.valid = false;
    }

    private void invalidate(boolean setIncluded) {
        DefaultTristateTreeNode parent;
        if (!setIncluded && !this.valid) {
            return;
        }
        this.valid = false;
        if (setIncluded) {
            this.included = true;
        }
        if ((parent = (DefaultTristateTreeNode)this.getParent()) != null) {
            parent.invalidate(setIncluded);
        }
    }

    private void validate() {
        if (!this.valid) {
            if (this.included) {
                this.state = this.selected ? TristateCheckBox.SELECTED : TristateCheckBox.NOT_SELECTED;
                for (int i = 0; i < this.getChildCount(); ++i) {
                    TristateTreeNode node = (TristateTreeNode)this.getChildAt(i);
                    TristateCheckBox.State childState = node.getState();
                    if (childState == TristateCheckBox.SELECTED && this.state == TristateCheckBox.SELECTED || childState == TristateCheckBox.NOT_SELECTED && this.state == TristateCheckBox.NOT_SELECTED) continue;
                    this.state = TristateCheckBox.DONT_CARE;
                    break;
                }
            } else {
                this.state = TristateCheckBox.NOT_SELECTED;
            }
            this.valid = true;
        }
    }

    public TristateCheckBox.State getState() {
        this.validate();
        return this.state;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void include(boolean included) {
        if (this.included != included) {
            this.invalidate(included);
            this.included = included;
        }
        if (included && this.getState() == TristateCheckBox.NOT_SELECTED) {
            this.setSelected(true);
        }
    }

    public void setIncluded(boolean included) {
        if (this.included == included) {
            return;
        }
        this.included = included;
        this.valid = false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        this.invalidate(true);
    }

    public void setUserObject(Object obj) {
        if (obj == this) {
            return;
        }
        super.setUserObject(obj);
    }

    public String toString() {
        return this.getClass().getName() + " i:" + this.included + " s:" + this.selected + " v:" + this.valid + " " + this.getUserObject();
    }
}

