/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.util;

import hep.wired.util.XYZandUVWindices;
import java.awt.geom.NoninvertibleTransformException;
import java.text.DecimalFormat;
import org.freehep.xml.io.XMLIO;
import org.freehep.xml.io.XMLIOManager;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class Matrix2D
implements XYZandUVWindices,
Cloneable,
XMLIO {
    private static final DecimalFormat fmt = new DecimalFormat("0000.000");
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;

    public Matrix2D() {
        this(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public Matrix2D(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.set(m00, m10, m01, m11, m02, m12);
    }

    public Object clone() {
        return new Matrix2D(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.m00);
        bits = bits * 31L + Double.doubleToLongBits(this.m10);
        bits = bits * 31L + Double.doubleToLongBits(this.m01);
        bits = bits * 31L + Double.doubleToLongBits(this.m11);
        bits = bits * 31L + Double.doubleToLongBits(this.m02);
        bits = bits * 31L + Double.doubleToLongBits(this.m12);
        return (int)bits ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix2D)) {
            return super.equals(obj);
        }
        Matrix2D m = (Matrix2D)obj;
        return m.m00 == this.m00 && m.m10 == this.m10 && m.m01 == this.m01 && m.m11 == this.m11 && m.m02 == this.m02 && m.m12 == this.m12;
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    private void set(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
    }

    public double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public Matrix2D createInverse() throws NoninvertibleTransformException {
        double d = this.getDeterminant();
        if (Math.abs(d) <= Double.MIN_VALUE) {
            throw new NoninvertibleTransformException("Matrix2D cannot be inverted. Determinant: " + d + "\n" + this.toString());
        }
        return new Matrix2D(this.m11 / d, -this.m10 / d, -this.m01 / d, this.m00 / d, (this.m01 * this.m12 - this.m11 * this.m02) / d, (this.m10 * this.m02 - this.m00 * this.m12) / d);
    }

    public void concatenate(Matrix2D m) {
        this.set(this.m00 * m.m00 + this.m01 * m.m10, this.m10 * m.m00 + this.m11 * m.m10, this.m00 * m.m01 + this.m01 * m.m11, this.m10 * m.m01 + this.m11 * m.m11, this.m00 * m.m02 + this.m01 * m.m12 + this.m02, this.m10 * m.m02 + this.m11 * m.m12 + this.m12);
    }

    public void preConcatenate(Matrix2D m) {
        this.set(m.m00 * this.m00 + m.m01 * this.m10, m.m10 * this.m00 + m.m11 * this.m10, m.m00 * this.m01 + m.m01 * this.m11, m.m10 * this.m01 + m.m11 * this.m11, m.m00 * this.m02 + m.m01 * this.m12 + m.m02, m.m10 * this.m02 + m.m11 * this.m12 + m.m12);
    }

    public void rotate(double theta) {
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        this.set(cos * this.m00 - sin * this.m10, sin * this.m00 + cos * this.m10, cos * this.m01 - sin * this.m11, sin * this.m01 + cos * this.m11, cos * this.m02 - sin * this.m12, sin * this.m02 + cos * this.m12);
    }

    public void scale(double sx, double sy) {
        this.m00 *= sx;
        this.m01 *= sx;
        this.m02 *= sx;
        this.m10 *= sy;
        this.m11 *= sy;
        this.m12 *= sy;
    }

    public void shear(double shx, double shy) {
        this.set(this.m00 + shx * this.m10, this.m10 + shy * this.m00, this.m01 + shx * this.m11, this.m11 + shy * this.m01, this.m02 + shx * this.m12, this.m12 + shy * this.m02);
    }

    public void translate(double tx, double ty) {
        this.m02 += tx;
        this.m12 += ty;
    }

    public void modelTranslate(double tx, double ty) {
        this.m02 += this.m00 * tx + this.m01 * ty;
        this.m12 += this.m10 * tx + this.m11 * ty;
    }

    public double[] transform(double[] xyz, boolean delta) {
        boolean d = !delta;
        double x = xyz[0];
        double y = xyz[1];
        xyz[0] = this.m00 * x + this.m01 * y + this.m02 * (double)d;
        xyz[1] = this.m10 * x + this.m11 * y + this.m12 * (double)d;
        return xyz;
    }

    public double[][] transform(double[][] xyz, int n, boolean delta) {
        boolean d = !delta;
        for (int i = 0; i < n; ++i) {
            double x = xyz[0][i];
            double y = xyz[1][i];
            xyz[0][i] = this.m00 * x + this.m01 * y + this.m02 * (double)d;
            xyz[1][i] = this.m10 * x + this.m11 * y + this.m12 * (double)d;
        }
        return xyz;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Matrix2D: ");
        s.append(fmt.format(this.m00));
        s.append(", ");
        s.append(fmt.format(this.m01));
        s.append(", ");
        s.append(fmt.format(this.m02));
        s.append("\n");
        s.append("          ");
        s.append(fmt.format(this.m10));
        s.append(", ");
        s.append(fmt.format(this.m11));
        s.append(", ");
        s.append(fmt.format(this.m12));
        s.append("\n");
        return s.toString();
    }

    public void save(XMLIOManager xmlioManager, Element nodeEl) {
        nodeEl.setAttribute("m00", Double.toString(this.m00));
        nodeEl.setAttribute("m10", Double.toString(this.m10));
        nodeEl.setAttribute("m01", Double.toString(this.m01));
        nodeEl.setAttribute("m11", Double.toString(this.m11));
        nodeEl.setAttribute("m02", Double.toString(this.m02));
        nodeEl.setAttribute("m12", Double.toString(this.m12));
    }

    public void restore(XMLIOManager xmlioManager, Element nodeEl) {
        try {
            this.set(nodeEl.getAttribute("m00").getDoubleValue(), nodeEl.getAttribute("m10").getDoubleValue(), nodeEl.getAttribute("m01").getDoubleValue(), nodeEl.getAttribute("m11").getDoubleValue(), nodeEl.getAttribute("m02").getDoubleValue(), nodeEl.getAttribute("m12").getDoubleValue());
        }
        catch (DataConversionException dce) {
            throw new IllegalArgumentException(this.getClass() + ": " + dce.getMessage());
        }
    }
}

