/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.util;

import hep.wired.util.XYZandUVWindices;
import java.awt.geom.NoninvertibleTransformException;
import java.text.DecimalFormat;
import org.freehep.xml.io.XMLIO;
import org.freehep.xml.io.XMLIOManager;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class Matrix3D
implements XYZandUVWindices,
Cloneable,
XMLIO {
    private static final DecimalFormat fmt = new DecimalFormat("0000.000");
    private double m00;
    private double m01;
    private double m02;
    private double m03;
    private double m10;
    private double m11;
    private double m12;
    private double m13;
    private double m20;
    private double m21;
    private double m22;
    private double m23;
    private boolean orthoNormalized;

    public Matrix3D() {
        this(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
    }

    public Matrix3D(double m00, double m10, double m20, double m01, double m11, double m21, double m02, double m12, double m22, double m03, double m13, double m23) {
        this.set(m00, m10, m20, m01, m11, m21, m02, m12, m22, m03, m13, m23);
    }

    public Object clone() {
        return new Matrix3D(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22, this.m03, this.m13, this.m23);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.m00);
        bits = bits * 31L + Double.doubleToLongBits(this.m10);
        bits = bits * 31L + Double.doubleToLongBits(this.m20);
        bits = bits * 31L + Double.doubleToLongBits(this.m01);
        bits = bits * 31L + Double.doubleToLongBits(this.m11);
        bits = bits * 31L + Double.doubleToLongBits(this.m21);
        bits = bits * 31L + Double.doubleToLongBits(this.m02);
        bits = bits * 31L + Double.doubleToLongBits(this.m12);
        bits = bits * 31L + Double.doubleToLongBits(this.m22);
        bits = bits * 31L + Double.doubleToLongBits(this.m03);
        bits = bits * 31L + Double.doubleToLongBits(this.m13);
        bits = bits * 31L + Double.doubleToLongBits(this.m23);
        return (int)bits ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix3D)) {
            return super.equals(obj);
        }
        Matrix3D m = (Matrix3D)obj;
        return m.m00 == this.m00 && m.m10 == this.m10 && m.m20 == this.m20 && m.m01 == this.m01 && m.m11 == this.m11 && m.m21 == this.m21 && m.m02 == this.m02 && m.m12 == this.m12 && m.m22 == this.m22 && m.m03 == this.m03 && m.m13 == this.m13 && m.m23 == this.m23;
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getScaleZ() {
        return this.m22;
    }

    public double getTranslateX() {
        return this.m03;
    }

    public double getTranslateY() {
        return this.m13;
    }

    public double getTranslateZ() {
        return this.m23;
    }

    public static Matrix3D getRotateInstance(double theta, double nx, double ny, double nz) {
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double one_cos = 1.0 - cos;
        return new Matrix3D(cos + nx * nx * one_cos, ny * nx * one_cos + nz * sin, nz * nx * one_cos - ny * sin, nx * ny * one_cos - nz * sin, cos + ny * ny * one_cos, nz * ny * one_cos + nx * sin, nx * nz * one_cos + ny * sin, ny * nz * one_cos - nx * sin, cos + nz * nz * one_cos, 0.0, 0.0, 0.0);
    }

    public static Matrix3D getRotateInstance(double phi, double theta, double omega) {
        Matrix3D m = new Matrix3D();
        if (omega != 0.0) {
            m.rotate(omega, 0.0, 0.0, 1.0);
        }
        if (theta != 0.0) {
            m.rotate(theta, 1.0, 0.0, 0.0);
        }
        if (phi != 0.0) {
            m.rotate(phi, 0.0, 1.0, 0.0);
        }
        return m;
    }

    public void rotateX(double phi) {
        double cos = Math.cos(phi);
        double sin = Math.sin(phi);
        this.set(this.m00, this.m10, this.m20, this.m01 * cos + this.m02 * sin, this.m11 * cos + this.m12 * sin, this.m21 * cos + this.m22 * sin, -this.m01 * sin + this.m02 * cos, -this.m11 * sin + this.m12 * cos, -this.m21 * sin + this.m22 * cos, this.m03, this.m13, this.m23);
    }

    public void rotateY(double theta) {
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        this.set(this.m00 * cos - this.m02 * sin, this.m10 * cos - this.m12 * sin, this.m20 * cos - this.m22 * sin, this.m01, this.m11, this.m21, this.m00 * sin + this.m02 * cos, this.m10 * sin + this.m12 * cos, this.m20 * sin - this.m22 * cos, this.m03, this.m13, this.m23);
    }

    public void rotateZ(double omega) {
        double cos = Math.cos(omega);
        double sin = Math.sin(omega);
        this.set(this.m00 * cos + this.m01 * sin, this.m10 * cos + this.m11 * sin, this.m20 * cos + this.m21 * sin, -this.m00 * sin + this.m01 * cos, -this.m10 * sin + this.m11 * cos, -this.m20 * sin + this.m21 * cos, this.m02, this.m12, this.m22, this.m03, this.m13, this.m23);
    }

    public void rotate(double theta, double nx, double ny, double nz) {
        this.preConcatenate(Matrix3D.getRotateInstance(theta, nx, ny, nz));
    }

    public void scale(double sx, double sy, double sz) {
        this.m00 *= sx;
        this.m01 *= sx;
        this.m02 *= sx;
        this.m03 *= sx;
        this.m10 *= sy;
        this.m11 *= sy;
        this.m12 *= sy;
        this.m13 *= sy;
        this.m20 *= sz;
        this.m21 *= sz;
        this.m22 *= sz;
        this.m23 *= sz;
        this.orthoNormalized = false;
    }

    public void shear(double shx, double shy) {
        this.set(this.m00 + shx * this.m10, this.m10 + shy * this.m00, this.m20, this.m01 + shx * this.m11, this.m11 + shy * this.m01, this.m21, this.m02 + shx * this.m12, this.m12 + shy * this.m02, this.m22, this.m03 + shx * this.m13, this.m13 + shy * this.m03, this.m23);
    }

    public void translate(double tx, double ty, double tz) {
        this.m03 += tx;
        this.m13 += ty;
        this.m23 += tz;
    }

    public void modelTranslate(double tx, double ty, double tz) {
        this.m03 += this.m00 * tx + this.m01 * ty + this.m02 * tz;
        this.m13 += this.m10 * tx + this.m11 * ty + this.m12 * tz;
        this.m23 += this.m20 * tx + this.m21 * ty + this.m22 * tz;
    }

    private void set(double m00, double m10, double m20, double m01, double m11, double m21, double m02, double m12, double m22, double m03, double m13, double m23) {
        this.m00 = m00;
        this.m10 = m10;
        this.m20 = m20;
        this.m01 = m01;
        this.m11 = m11;
        this.m21 = m21;
        this.m02 = m02;
        this.m12 = m12;
        this.m22 = m22;
        this.m03 = m03;
        this.m13 = m13;
        this.m23 = m23;
        this.orthoNormalized = false;
    }

    public double getRotation(double[] n) {
        Matrix3D m = this.orthoNormalized ? this : this.createOrthonormalized();
        double cosTheta = (m.m00 + m.m11 + m.m22 - 1.0) / 2.0;
        double theta = Math.acos(cosTheta);
        double twoSinTheta = 2.0 * Math.sin(theta);
        if (twoSinTheta == 0.0) {
            n[2] = 0.0;
            n[1] = 0.0;
            n[0] = 0.0;
        } else {
            n[0] = (m.m21 - m.m12) / twoSinTheta;
            n[1] = (m.m02 - m.m20) / twoSinTheta;
            n[2] = (m.m01 - m.m10) / twoSinTheta;
        }
        return theta;
    }

    public double getDeterminant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 - (this.m00 * this.m12 - this.m02 * this.m10) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix3D createOrthonormalized() {
        Matrix3D r = new Matrix3D();
        r.m00 = this.m00;
        r.m10 = this.m10;
        r.m20 = this.m20;
        double v1length = r.m00 * r.m00 + r.m10 * r.m10 + r.m20 * r.m20;
        double p1 = (this.m01 * r.m00 + this.m11 * r.m10 + this.m21 * r.m20) / v1length;
        r.m01 = this.m01 - p1 * this.m00;
        r.m11 = this.m11 - p1 * this.m10;
        r.m21 = this.m21 - p1 * this.m20;
        double v2length = r.m01 * r.m01 + r.m11 * r.m11 + r.m21 * r.m21;
        p1 = (this.m02 * r.m00 + this.m12 * r.m10 + this.m22 * r.m20) / v1length;
        double p2 = (this.m02 * r.m01 + this.m12 * r.m11 + this.m22 * r.m21) / v2length;
        r.m02 = this.m02 - p1 * this.m00 - p2 * this.m01;
        r.m12 = this.m12 - p1 * this.m10 - p2 * this.m11;
        r.m22 = this.m22 - p1 * this.m20 - p2 * this.m21;
        double v3length = r.m02 * r.m02 + r.m12 * r.m12 + r.m22 * r.m22;
        double v1n = Math.sqrt(v1length);
        double v2n = Math.sqrt(v2length);
        double v3n = Math.sqrt(v3length);
        r.m00 /= v1n;
        r.m10 /= v1n;
        r.m20 /= v1n;
        r.m01 /= v2n;
        r.m11 /= v2n;
        r.m21 /= v2n;
        r.m02 /= v3n;
        r.m12 /= v3n;
        r.m22 /= v3n;
        return r;
    }

    public Matrix3D createNormalized() {
        Matrix3D r = (Matrix3D)this.clone();
        double v1n = Math.sqrt(r.m00 * r.m00 + r.m10 * r.m10 + r.m20 * r.m20);
        double v2n = Math.sqrt(r.m01 * r.m01 + r.m11 * r.m11 + r.m21 * r.m21);
        double v3n = Math.sqrt(r.m02 * r.m02 + r.m12 * r.m12 + r.m22 * r.m22);
        r.m00 /= v1n;
        r.m10 /= v1n;
        r.m20 /= v1n;
        r.m01 /= v2n;
        r.m11 /= v2n;
        r.m21 /= v2n;
        r.m02 /= v3n;
        r.m12 /= v3n;
        r.m22 /= v3n;
        return r;
    }

    public Matrix3D createInverse() throws NoninvertibleTransformException {
        double d = this.getDeterminant();
        if (Math.abs(d) <= Double.MIN_VALUE) {
            throw new NoninvertibleTransformException("Matrix3D cannot be inverted. Determinant: " + d + "\n" + this.toString());
        }
        return new Matrix3D((this.m11 * this.m22 - this.m12 * this.m21) / d, (this.m12 * this.m20 - this.m10 * this.m22) / d, (this.m10 * this.m21 - this.m11 * this.m20) / d, (this.m21 * this.m02 - this.m22 * this.m01) / d, (this.m22 * this.m00 - this.m20 * this.m02) / d, (this.m20 * this.m01 - this.m21 * this.m00) / d, (this.m01 * this.m12 - this.m02 * this.m11) / d, (this.m02 * this.m10 - this.m00 * this.m12) / d, (this.m00 * this.m11 - this.m01 * this.m10) / d, (this.m01 * (this.m13 * this.m22 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m13 * this.m21) + this.m03 * (this.m12 * this.m21 - this.m11 * this.m22)) / d, (this.m02 * (this.m13 * this.m20 - this.m10 * this.m23) + this.m03 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m00 * (this.m12 * this.m23 - this.m13 * this.m22)) / d, (this.m03 * (this.m11 * this.m20 - this.m10 * this.m21) + this.m00 * (this.m13 * this.m21 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m13 * this.m20)) / d);
    }

    public void concatenate(Matrix3D m) {
        this.set(this.m00 * m.m00 + this.m01 * m.m10 + this.m02 * m.m20, this.m10 * m.m00 + this.m11 * m.m10 + this.m12 * m.m20, this.m20 * m.m00 + this.m21 * m.m10 + this.m22 * m.m20, this.m00 * m.m01 + this.m01 * m.m11 + this.m02 * m.m21, this.m10 * m.m01 + this.m11 * m.m11 + this.m12 * m.m21, this.m20 * m.m01 + this.m21 * m.m11 + this.m22 * m.m21, this.m00 * m.m02 + this.m01 * m.m12 + this.m02 * m.m22, this.m10 * m.m02 + this.m11 * m.m12 + this.m12 * m.m22, this.m20 * m.m02 + this.m21 * m.m12 + this.m22 * m.m22, this.m00 * m.m03 + this.m01 * m.m13 + this.m02 * m.m23 + this.m03, this.m10 * m.m03 + this.m11 * m.m13 + this.m12 * m.m23 + this.m13, this.m20 * m.m03 + this.m21 * m.m13 + this.m22 * m.m23 + this.m23);
    }

    public void preConcatenate(Matrix3D m) {
        this.set(m.m00 * this.m00 + m.m01 * this.m10 + m.m02 * this.m20, m.m10 * this.m00 + m.m11 * this.m10 + m.m12 * this.m20, m.m20 * this.m00 + m.m21 * this.m10 + m.m22 * this.m20, m.m00 * this.m01 + m.m01 * this.m11 + m.m02 * this.m21, m.m10 * this.m01 + m.m11 * this.m11 + m.m12 * this.m21, m.m20 * this.m01 + m.m21 * this.m11 + m.m22 * this.m21, m.m00 * this.m02 + m.m01 * this.m12 + m.m02 * this.m22, m.m10 * this.m02 + m.m11 * this.m12 + m.m12 * this.m22, m.m20 * this.m02 + m.m21 * this.m12 + m.m22 * this.m22, m.m00 * this.m03 + m.m01 * this.m13 + m.m02 * this.m23 + m.m03, m.m10 * this.m03 + m.m11 * this.m13 + m.m12 * this.m23 + m.m13, m.m20 * this.m03 + m.m21 * this.m13 + m.m22 * this.m23 + m.m23);
    }

    public double[] transform(double[] xyz, boolean delta) {
        boolean d = !delta;
        double x = xyz[0];
        double y = xyz[1];
        double z = xyz[2];
        xyz[0] = this.m00 * x + this.m01 * y + this.m02 * z + this.m03 * (double)d;
        xyz[1] = this.m10 * x + this.m11 * y + this.m12 * z + this.m13 * (double)d;
        xyz[2] = this.m20 * x + this.m21 * y + this.m22 * z + this.m23 * (double)d;
        return xyz;
    }

    public double[][] transform(double[][] xyz, int n, boolean delta) {
        boolean d = !delta;
        for (int i = 0; i < n; ++i) {
            double x = xyz[0][i];
            double y = xyz[1][i];
            double z = xyz[2][i];
            xyz[0][i] = this.m00 * x + this.m01 * y + this.m02 * z + this.m03 * (double)d;
            xyz[1][i] = this.m10 * x + this.m11 * y + this.m12 * z + this.m13 * (double)d;
            xyz[2][i] = this.m20 * x + this.m21 * y + this.m22 * z + this.m23 * (double)d;
        }
        return xyz;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Matrix3D: ");
        s.append(fmt.format(this.m00));
        s.append(", ");
        s.append(fmt.format(this.m01));
        s.append(", ");
        s.append(fmt.format(this.m02));
        s.append(", ");
        s.append(fmt.format(this.m03));
        s.append("\n");
        s.append("          ");
        s.append(fmt.format(this.m10));
        s.append(", ");
        s.append(fmt.format(this.m11));
        s.append(", ");
        s.append(fmt.format(this.m12));
        s.append(", ");
        s.append(fmt.format(this.m13));
        s.append("\n");
        s.append("          ");
        s.append(fmt.format(this.m20));
        s.append(", ");
        s.append(fmt.format(this.m21));
        s.append(", ");
        s.append(fmt.format(this.m22));
        s.append(", ");
        s.append(fmt.format(this.m23));
        s.append("\n");
        return s.toString();
    }

    public void save(XMLIOManager xmlioManager, Element nodeEl) {
        nodeEl.setAttribute("m00", Double.toString(this.m00));
        nodeEl.setAttribute("m10", Double.toString(this.m10));
        nodeEl.setAttribute("m20", Double.toString(this.m20));
        nodeEl.setAttribute("m01", Double.toString(this.m01));
        nodeEl.setAttribute("m11", Double.toString(this.m11));
        nodeEl.setAttribute("m21", Double.toString(this.m21));
        nodeEl.setAttribute("m02", Double.toString(this.m02));
        nodeEl.setAttribute("m12", Double.toString(this.m12));
        nodeEl.setAttribute("m22", Double.toString(this.m22));
        nodeEl.setAttribute("m03", Double.toString(this.m03));
        nodeEl.setAttribute("m13", Double.toString(this.m13));
        nodeEl.setAttribute("m23", Double.toString(this.m23));
    }

    public void restore(XMLIOManager xmlioManager, Element nodeEl) {
        try {
            this.set(nodeEl.getAttribute("m00").getDoubleValue(), nodeEl.getAttribute("m10").getDoubleValue(), nodeEl.getAttribute("m20").getDoubleValue(), nodeEl.getAttribute("m01").getDoubleValue(), nodeEl.getAttribute("m11").getDoubleValue(), nodeEl.getAttribute("m21").getDoubleValue(), nodeEl.getAttribute("m02").getDoubleValue(), nodeEl.getAttribute("m12").getDoubleValue(), nodeEl.getAttribute("m22").getDoubleValue(), nodeEl.getAttribute("m03").getDoubleValue(), nodeEl.getAttribute("m13").getDoubleValue(), nodeEl.getAttribute("m23").getDoubleValue());
        }
        catch (DataConversionException dce) {
            throw new IllegalArgumentException(this.getClass() + ": " + dce.getMessage());
        }
    }
}

