/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.freehep.swing.table.SortableTableModel;

public abstract class SortableListTableModel
extends AbstractTableModel
implements SortableTableModel {
    private String[] names;
    private Class[] types;
    private List keys;
    private transient int sortOnColumn = -1;
    private transient boolean sortAscending = true;

    public SortableListTableModel(String[] names, Class[] types, List keys) {
        this.names = names;
        this.types = types;
        this.keys = keys;
    }

    protected List getKeys() {
        return this.keys;
    }

    public String getColumnName(int col) {
        return this.names[col];
    }

    public int getColumnCount() {
        return this.names.length;
    }

    public Class getColumnClass(int c) {
        return c < this.types.length ? this.types[c] : String.class;
    }

    public int getRowCount() {
        return this.keys.size();
    }

    public void sort(int column, boolean ascending) {
        if (column != this.sortOnColumn || ascending != this.sortAscending) {
            this.sortOnColumn = column;
            this.sortAscending = ascending;
            this.sort();
        }
        super.fireTableDataChanged();
    }

    public void fireTableDataChanged() {
        this.sort();
        super.fireTableDataChanged();
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.sort();
        super.fireTableRowsInserted(firstRow, lastRow);
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.sort();
        super.fireTableRowsUpdated(firstRow, lastRow);
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.sort();
        super.fireTableRowsDeleted(firstRow, lastRow);
    }

    public void fireTableCellUpdated(int row, int column) {
        if (column == this.sortOnColumn) {
            this.sort();
        }
        super.fireTableCellUpdated(row, column);
    }

    public void fireTableStructureChanged() {
        this.sortOnColumn = -1;
        this.sortAscending = true;
        this.sort();
        super.fireTableStructureChanged();
    }

    protected abstract int compareKeys(Object var1, Object var2, int var3, boolean var4);

    private void sort() {
        Collections.sort(this.keys, new Comparator(){

            public int compare(Object o1, Object o2) {
                return SortableListTableModel.this.compareKeys(o1, o2, SortableListTableModel.this.sortOnColumn, SortableListTableModel.this.sortAscending);
            }
        });
    }
}

