/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.util;

import hep.wired.util.SwingEventMulticaster;
import hep.wired.util.TristateCheckBox;
import hep.wired.util.TristateTreeCellRenderer;
import hep.wired.util.TristateTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public class TristateTreeCellEditor
extends TristateTreeCellRenderer
implements TreeCellEditor {
    private boolean select;
    private boolean local;
    protected CellEditorListener list;

    public TristateTreeCellEditor(JTree tree) {
        this(tree, new TristateTreeCellRenderer.NoIconTreeCellRenderer());
    }

    public TristateTreeCellEditor(JTree tree, TreeCellRenderer renderer) {
        super(tree, renderer);
        this.tristate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TristateTreeCellEditor.this.local = false;
                TristateTreeCellEditor.this.select = false;
                TristateTreeCellEditor.this.fireEditingStopped();
            }
        });
        this.check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TristateTreeCellEditor.this.local = true;
                TristateTreeCellEditor.this.select = false;
                TristateTreeCellEditor.this.fireEditingStopped();
            }
        });
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        return this.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
    }

    public boolean stopCellEditing() {
        return true;
    }

    public Object getCellEditorValue() {
        if (!this.select && this.node instanceof TristateTreeNode) {
            TristateTreeNode treeNode = (TristateTreeNode)this.node;
            if (this.local) {
                treeNode.setSelected(this.check.isSelected());
            } else {
                treeNode.include(treeNode.getState() == TristateCheckBox.NOT_SELECTED);
            }
        }
        this.select = true;
        return this.node;
    }

    public boolean isCellEditable(EventObject event) {
        return true;
    }

    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.list = SwingEventMulticaster.add(this.list, listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.list = SwingEventMulticaster.remove(this.list, listener);
    }

    protected void fireEditingStopped() {
        if (this.list != null) {
            this.list.editingStopped(new ChangeEvent(this));
        }
    }

    protected void fireEditingCanceled() {
        if (this.list != null) {
            this.list.editingCanceled(new ChangeEvent(this));
        }
    }
}

