/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.util;

import hep.wired.util.TristateCheckBox;
import hep.wired.util.TristateTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TristateTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    protected Object node;
    protected TreeCellRenderer renderer;
    protected TristateCheckBox tristate;
    protected Component strut;
    protected JCheckBox check;
    protected Component component;

    public TristateTreeCellRenderer(JTree tree) {
        this(tree, new NoIconTreeCellRenderer());
    }

    public TristateTreeCellRenderer(JTree tree, TreeCellRenderer renderer) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.renderer = renderer;
        this.component = renderer.getTreeCellRendererComponent(tree, "", true, true, true, 0, true);
        this.add("Center", this.component);
        this.tristate = new TristateCheckBox();
        this.tristate.setMargin(new Insets(0, 0, 0, 0));
        this.tristate.setBorderPaintedFlat(true);
        this.tristate.setOpaque(false);
        this.tristate.setToolTipText("Changes visibility of all objects in this group. Status shows if 'all', 'some' or 'no' objects are visible from this group.");
        this.check = new JCheckBox();
        this.check.setMargin(new Insets(0, 0, 0, 0));
        this.check.setBorderPaintedFlat(true);
        this.check.setOpaque(false);
        this.check.setToolTipText("Changes visibility of this object. Status shows if this object is visible.");
        Box box = Box.createHorizontalBox();
        box.add(this.tristate);
        this.strut = Box.createHorizontalStrut(3);
        box.add(this.strut);
        box.add(this.check);
        this.add("West", box);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.node = value;
        if (this.node instanceof TristateTreeNode) {
            TristateTreeNode treeNode = (TristateTreeNode)this.node;
            this.tristate.setState(treeNode.getState());
            this.check.setSelected(treeNode.isSelected());
        }
        if (this.node instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)this.node).getUserObject();
        }
        this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.tristate.setVisible(!leaf);
        this.strut.setVisible(!leaf);
        this.setEnabled(this.component.isEnabled());
        this.invalidate();
        return this;
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.tristate.setEnabled(state);
        this.strut.setEnabled(state);
        this.check.setEnabled(state);
        this.component.setEnabled(state);
    }

    public static class NoIconTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Icon getOpenIcon() {
            return null;
        }

        public Icon getClosedIcon() {
            return null;
        }

        public Icon getLeafIcon() {
            return null;
        }
    }
}

