/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.util;

import hep.wired.util.DefaultTristateTreeNode;
import hep.wired.util.TristateCheckBox;
import hep.wired.util.TristateTreeNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TristateTreeModel
implements TreeModel,
TreeModelListener {
    protected List treeModelListeners = new ArrayList();
    protected TreeModel model;
    protected TristateTreeNode root = null;

    public TristateTreeModel() {
        this(null);
    }

    public TristateTreeModel(TreeModel model) {
        this.setModel(model);
    }

    public void setModel(TreeModel newModel) {
        if (this.model != null) {
            this.model.removeTreeModelListener(this);
        }
        this.model = newModel;
        if (this.model != null) {
            this.model.addTreeModelListener(this);
        }
        this.root = null;
        this.root = (TristateTreeNode)this.getRoot();
        this.fireTreeStructureChanged();
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return value != null ? value.toString() : "null";
    }

    protected void checkForChildren(TristateTreeNode parent, TreeModel model, boolean recursive) {
        Object modelParent = parent.getUserObject();
        int n = model.getChildCount(modelParent);
        if (parent.getChildCount() != n) {
            for (int i = 0; i < n; ++i) {
                TristateTreeNode child = this.createTreeNode(model.getChild(modelParent, i));
                parent.add(child);
                if (!recursive) continue;
                this.checkForChildren(child, model, recursive);
            }
        }
    }

    protected TristateTreeNode createTreeNode(Object modelNode) {
        return new DefaultTristateTreeNode(modelNode);
    }

    public Set getSelectedSet(Class type) {
        return this.getSelectedSet(type, Integer.MAX_VALUE);
    }

    public Set getSelectedSet(Class type, int maxLevel) {
        HashSet set = new HashSet();
        TristateTreeNode node = (TristateTreeNode)this.getRoot();
        if (node != null && node.getState() != TristateCheckBox.NOT_SELECTED) {
            this.addSelected(set, node, type, Math.max(maxLevel, maxLevel + 2));
        }
        return set;
    }

    private void addSelected(Set set, TristateTreeNode node, Class type, int level) {
        if (level <= 0) {
            return;
        }
        if (node.isSelected()) {
            Object object = node.getUserObject();
            if (type == null || type.isAssignableFrom(object.getClass())) {
                set.add(object);
            }
        }
        int n = this.getChildCount(node);
        for (int i = 0; i < n; ++i) {
            TristateTreeNode child = (TristateTreeNode)this.getChild(node, i);
            if (child.getState() == TristateCheckBox.NOT_SELECTED) continue;
            this.addSelected(set, child, type, level - 1);
        }
    }

    public Object getRoot() {
        if (this.root == null && this.model != null && this.model.getRoot() != null) {
            this.root = new DefaultTristateTreeNode(this.model.getRoot());
            this.checkForChildren(this.root, this.model, true);
        }
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        return ((TristateTreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((TristateTreeNode)parent).getChildCount();
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        if (this.model != null) {
            this.model.valueForPathChanged(path, newValue);
        }
        this.treeNodesChanged(new TreeModelEvent((Object)this, path));
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof TreeNode && child instanceof TreeNode) {
            return ((TreeNode)parent).getIndex((TreeNode)child);
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public void fireTreeStructureChanged() {
        if (this.root == null) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.root});
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeStructureChanged(e);
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesChanged(e);
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesInserted(e);
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeNodesRemoved(e);
        }
    }

    public void treeStructureChanged(TreeModelEvent e) {
        this.root = null;
        Iterator i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            ((TreeModelListener)i.next()).treeStructureChanged(e);
        }
    }
}

