/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.util.test;

import hep.wired.util.DefaultTristateTreeNode;
import hep.wired.util.JTristateTree;
import hep.wired.util.TristateTreeModel;
import hep.wired.util.TristateTreeNode;
import hep.wired.util.test.TristateTestNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;

public class JTristateTreeTest
extends JPanel {
    public JTristateTreeTest() {
        this.setLayout(new BorderLayout());
        TristateTestNode root = new TristateTestNode("Root");
        TristateTestNode geometry = new TristateTestNode("Geometry");
        root.add(geometry);
        TristateTestNode box1 = new TristateTestNode("Box1");
        geometry.add(box1);
        box1.add(new TristateTestNode("Panel1", false));
        box1.add(new TristateTestNode("Panel2"));
        box1.add(new TristateTestNode("Panel3", false));
        TristateTestNode box2 = new TristateTestNode("Box2");
        geometry.add(box2);
        box2.add(new TristateTestNode("PanelA"));
        box2.add(new TristateTestNode("PanelB"));
        TristateTestNode event = new TristateTestNode("Event");
        root.add(event);
        final TristateTreeModel model = new TristateTreeModel(new DefaultTreeModel(root)){

            protected TristateTreeNode createTreeNode(Object modelNode) {
                if (modelNode instanceof TristateTestNode) {
                    return new DefaultTristateTreeNode(modelNode, ((TristateTestNode)modelNode).isSelected());
                }
                return super.createTreeNode(modelNode);
            }
        };
        JTristateTree tree = new JTristateTree(model);
        tree.setRootVisible(true);
        tree.setShowsRootHandles(true);
        this.add((Component)new JScrollPane(tree), "Center");
        JButton button = new JButton("Print List");
        this.add((Component)button, "South");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.out.print("Selected: [");
                Iterator i = model.getSelectedSet(null).iterator();
                while (i.hasNext()) {
                    System.out.print(i.next());
                    if (!i.hasNext()) continue;
                    System.out.print(", ");
                }
                System.out.println("]");
            }
        });
    }

    public static void main(String[] args) {
        try {
            String plaf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(plaf);
        }
        catch (Exception e) {
            System.out.println("Error loading Look and Feel");
        }
        JFrame frame = new JFrame("JTristateCheckTree Test");
        frame.getContentPane().setLayout(new GridLayout(1, 1));
        frame.getContentPane().add(new JTristateTreeTest());
        frame.setSize(200, 400);
        frame.setVisible(true);
    }
}

