/*
 * Decompiled with CFR 0.152.
 */
package hep.wired.viewport;

import hep.wired.services.ViewPort;
import java.awt.geom.Rectangle2D;
import org.freehep.xml.io.XMLIOManager;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class RectangularViewPort
extends Rectangle2D.Double
implements ViewPort {
    private int componentWidth;
    private int componentHeight;

    public RectangularViewPort() {
        this(0.0, 0.0, 800.0, 600.0, 800, 600);
    }

    public RectangularViewPort(Rectangle2D r, int componentWidth, int componentHeight) {
        super(r.getX(), r.getY(), r.getWidth(), r.getWidth());
        this.init(componentWidth, componentHeight);
    }

    public RectangularViewPort(double x, double y, double width, double height, int componentWidth, int componentHeight) {
        super(x, y, width, height);
        this.init(componentWidth, componentHeight);
    }

    private void init(int componentWidth, int componentHeight) {
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
    }

    public int getComponentWidth() {
        return this.componentWidth;
    }

    public int getComponentHeight() {
        return this.componentHeight;
    }

    public String getID() {
        return this.getName();
    }

    public String getName() {
        return "RectangularViewPort";
    }

    public ViewPort copy() {
        return new RectangularViewPort(this, this.getComponentWidth(), this.getComponentHeight());
    }

    public double[] transform(double[] xyz) {
        xyz[0] = (xyz[0] + 1.0) * this.getWidth() / 2.0 + this.getX();
        xyz[1] = this.getHeight() - (xyz[1] + 1.0) * this.getHeight() / 2.0 + this.getY();
        xyz[2] = (xyz[2] + 1.0) * this.getWidth() / 2.0 + this.getX();
        return xyz;
    }

    public double[][] transform(double[][] xyz, int n) {
        for (int i = 0; i < n; ++i) {
            xyz[0][i] = (xyz[0][i] + 1.0) * this.getWidth() / 2.0 + this.getX();
            xyz[1][i] = this.getHeight() - (xyz[1][i] + 1.0) * this.getHeight() / 2.0 + this.getY();
            xyz[2][i] = (xyz[2][i] + 1.0) * this.getWidth() / 2.0 + this.getX();
        }
        return xyz;
    }

    public double[] deltaTransform(double[] xyz) {
        xyz[0] = xyz[0] * (this.getWidth() / 2.0);
        xyz[1] = xyz[1] * (this.getHeight() / 2.0);
        xyz[2] = xyz[2] * (this.getWidth() / 2.0);
        return xyz;
    }

    public double[] inverseTransform(double[] uvw) {
        uvw[0] = 2.0 * (uvw[0] - this.getX()) / this.getWidth() - 1.0;
        uvw[1] = 2.0 * (this.getY() - uvw[1]) / this.getHeight() + 1.0;
        uvw[2] = 2.0 * (uvw[2] - this.getX()) / this.getWidth() - 1.0;
        return uvw;
    }

    public double[] inverseDeltaTransform(double[] uvw) {
        uvw[0] = 2.0 * uvw[0] / this.getWidth();
        uvw[1] = 2.0 * uvw[1] / this.getHeight();
        uvw[2] = 2.0 * uvw[2] / this.getWidth();
        return uvw;
    }

    public String toString() {
        return this.getClass() + ": " + super.toString();
    }

    public void save(XMLIOManager xmlioManager, Element nodeEl) {
        nodeEl.setAttribute("x0", Double.toString(this.getX()));
        nodeEl.setAttribute("y0", Double.toString(this.getY()));
        nodeEl.setAttribute("width", Double.toString(this.getWidth()));
        nodeEl.setAttribute("height", Double.toString(this.getHeight()));
        nodeEl.setAttribute("componentWidth", Integer.toString(this.getComponentWidth()));
        nodeEl.setAttribute("componentHeight", Integer.toString(this.getComponentHeight()));
    }

    public void restore(XMLIOManager xmlioManager, Element nodeEl) {
        try {
            this.setRect(nodeEl.getAttribute("x0").getDoubleValue(), nodeEl.getAttribute("y0").getDoubleValue(), nodeEl.getAttribute("width").getDoubleValue(), nodeEl.getAttribute("height").getDoubleValue());
            this.componentWidth = nodeEl.getAttribute("componentWidth").getIntValue();
            this.componentHeight = nodeEl.getAttribute("componentHeight").getIntValue();
        }
        catch (DataConversionException dce) {
            throw new IllegalArgumentException(this.getClass() + ": " + dce.getMessage());
        }
    }
}

