/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpSocketHelper;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpServerTransport;

public class OncRpcTcpConnectionServerTransport
extends OncRpcServerTransport {
    private Socket socket;
    private OncRpcTcpSocketHelper socketHelper;
    private XdrTcpEncodingStream sendingXdr;
    private XdrTcpDecodingStream receivingXdr;
    private boolean pendingDecoding = false;
    private boolean pendingEncoding = false;
    private OncRpcTcpServerTransport parent;
    protected int transmissionTimeout;

    public OncRpcTcpConnectionServerTransport(OncRpcDispatchable dispatcher, Socket socket, int program, int version, int bufferSize, OncRpcTcpServerTransport parent, int transmissionTimeout) throws OncRpcException, IOException {
        this(dispatcher, socket, new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(program, version)}, bufferSize, parent, transmissionTimeout);
    }

    public OncRpcTcpConnectionServerTransport(OncRpcDispatchable dispatcher, Socket socket, OncRpcServerTransportRegistrationInfo[] info, int bufferSize, OncRpcTcpServerTransport parent, int transmissionTimeout) throws OncRpcException, IOException {
        super(dispatcher, 0, info);
        this.parent = parent;
        this.transmissionTimeout = transmissionTimeout;
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.socket = socket;
        this.port = socket.getLocalPort();
        this.socketHelper = new OncRpcTcpSocketHelper(socket);
        if (this.socketHelper.getSendBufferSize() < bufferSize) {
            this.socketHelper.setSendBufferSize(bufferSize);
        }
        if (this.socketHelper.getReceiveBufferSize() < bufferSize) {
            this.socketHelper.setReceiveBufferSize(bufferSize);
        }
        this.sendingXdr = new XdrTcpEncodingStream(socket, bufferSize);
        this.receivingXdr = new XdrTcpDecodingStream(socket, bufferSize);
        this.setCharacterEncoding(parent.getCharacterEncoding());
    }

    public void close() {
        Object deadXdrStream;
        if (this.socket != null) {
            Socket deadSocket = this.socket;
            this.socket = null;
            try {
                deadSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.sendingXdr != null) {
            deadXdrStream = this.sendingXdr;
            this.sendingXdr = null;
            try {
                ((XdrEncodingStream)deadXdrStream).close();
            }
            catch (IOException e) {
            }
            catch (OncRpcException e) {
                // empty catch block
            }
        }
        if (this.receivingXdr != null) {
            deadXdrStream = this.receivingXdr;
            this.receivingXdr = null;
            try {
                ((XdrDecodingStream)deadXdrStream).close();
            }
            catch (IOException e) {
            }
            catch (OncRpcException oncRpcException) {
                // empty catch block
            }
        }
        if (this.parent != null) {
            this.parent.removeTransport(this);
            this.parent = null;
        }
    }

    protected void finalize() {
        if (this.parent != null) {
            this.parent.removeTransport(this);
        }
    }

    public void register() throws OncRpcException {
        throw new Error("OncRpcTcpServerTransport.register() is abstract and can not be called.");
    }

    public void retrieveCall(XdrAble call) throws OncRpcException, IOException {
        call.xdrDecode(this.receivingXdr);
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    protected XdrDecodingStream getXdrDecodingStream() {
        return this.receivingXdr;
    }

    protected void endDecoding() throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    protected XdrEncodingStream getXdrEncodingStream() {
        return this.sendingXdr;
    }

    protected void beginEncoding(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state) throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
        this.pendingEncoding = true;
        this.sendingXdr.beginEncoding(callInfo.peerAddress, callInfo.peerPort);
        state.xdrEncode(this.sendingXdr);
    }

    protected void endEncoding() throws OncRpcException, IOException {
        this.sendingXdr.endEncoding();
        this.pendingEncoding = false;
    }

    protected void reply(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state, XdrAble reply) throws OncRpcException, IOException {
        this.beginEncoding(callInfo, state);
        if (reply != null) {
            reply.xdrEncode(this.sendingXdr);
        }
        this.endEncoding();
    }

    public void listen() {
        Thread listener = new Thread("TCP server transport connection thread"){

            public void run() {
                OncRpcTcpConnectionServerTransport.this._listen();
            }
        };
        listener.setDaemon(true);
        listener.start();
    }

    private void _listen() {
        OncRpcCallInformation callInfo = new OncRpcCallInformation(this);
        while (true) {
            try {
                this.socket.setSoTimeout(0);
                this.pendingDecoding = true;
                this.receivingXdr.beginDecoding();
                callInfo.peerAddress = this.receivingXdr.getSenderAddress();
                callInfo.peerPort = this.receivingXdr.getSenderPort();
                this.socket.setSoTimeout(this.transmissionTimeout);
            }
            catch (IOException e) {
                this.close();
                return;
            }
            catch (OncRpcException e) {
                this.close();
                return;
            }
            try {
                callInfo.callMessage.xdrDecode(this.receivingXdr);
            }
            catch (IOException e) {
                this.close();
                return;
            }
            catch (OncRpcException e) {
                if (!this.pendingDecoding) continue;
                this.pendingDecoding = false;
                try {
                    this.receivingXdr.endDecoding();
                    continue;
                }
                catch (IOException e2) {
                    this.close();
                    return;
                }
                catch (OncRpcException e2) {
                    continue;
                }
            }
            try {
                this.dispatcher.dispatchOncRpcCall(callInfo, callInfo.callMessage.program, callInfo.callMessage.version, callInfo.callMessage.procedure);
                continue;
            }
            catch (Exception e) {
                if (this.pendingEncoding) {
                    this.close();
                    return;
                }
                if (this.pendingDecoding) {
                    this.pendingDecoding = false;
                    try {
                        this.receivingXdr.endDecoding();
                    }
                    catch (IOException e2) {
                        this.close();
                        return;
                    }
                    catch (OncRpcException e2) {
                        // empty catch block
                    }
                }
                try {
                    if (e instanceof OncRpcAuthenticationException) {
                        callInfo.failAuthenticationFailed(((OncRpcAuthenticationException)e).getAuthStatus());
                        continue;
                    }
                    callInfo.failSystemError();
                    continue;
                }
                catch (IOException e2) {
                    this.close();
                    return;
                }
                catch (OncRpcException oncRpcException) {
                    continue;
                }
            }
            break;
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.sendingXdr.setCharacterEncoding(characterEncoding);
        this.receivingXdr.setCharacterEncoding(characterEncoding);
    }

    public String getCharacterEncoding() {
        return this.sendingXdr.getCharacterEncoding();
    }
}

