/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnnotation;
import hep.aida.IFunction;
import hep.aida.IRangeSet;
import hep.aida.dev.IDevModelFunction;
import hep.aida.ref.Annotation;
import hep.aida.ref.function.RangeSet;
import java.util.ArrayList;

public abstract class AbstractDevModelFunction
implements IDevModelFunction {
    protected int dimension;
    protected double[] x;
    protected double[] p;
    protected String[] varNames;
    protected String[] parNames;
    protected IAnnotation annotation;
    protected String codeletString;
    protected String title;
    protected IFunction function;
    protected ArrayList[] min;
    protected ArrayList[] max;
    private boolean providesGradient;
    private boolean gradientValid;
    private double[] gradient;
    private boolean providesParameterGradient;
    private boolean parameterGradientValid;
    private double[] parameterGradient;
    private boolean providesNormalization;
    private boolean isNormalized;
    private boolean normalizationValid;
    private double normalizationAmplitude;
    protected IRangeSet[] rangeSet;

    public AbstractDevModelFunction() {
        this.init();
    }

    public String normalizationParameter() {
        throw new UnsupportedOperationException("The normalizationParameter() method has not been implemented yet");
    }

    public abstract int dimension();

    public abstract int numberOfParameters();

    public abstract double functionValue(double[] var1);

    private void init() {
        this.dimension = -1;
        this.x = null;
        this.p = null;
        this.varNames = new String[]{"x0"};
        this.parNames = new String[]{"p0"};
        this.annotation = null;
        this.codeletString = null;
        this.function = null;
        this.min = null;
        this.max = null;
        this.gradient = null;
        this.parameterGradient = null;
        this.providesGradient = false;
        this.gradientValid = false;
        this.providesParameterGradient = false;
        this.parameterGradientValid = false;
        this.providesNormalization = false;
        this.isNormalized = false;
        this.normalizationValid = false;
        this.normalizationAmplitude = Double.NaN;
        this.annotation = new Annotation();
        this.rangeSet = new RangeSet[this.dimension];
        this.rangeSet[0] = new RangeSet();
    }

    public final double value(double[] var) {
        if (this.normalizationValid) {
            return this.normalizationAmplitude * this.functionValue(var);
        }
        this.normalizationAmplitude = this.normalizationAmplitude();
        this.normalizationValid = true;
        return this.normalizationAmplitude * this.functionValue(var);
    }

    public IAnnotation annotation() {
        return this.annotation;
    }

    public String variableName(int i) {
        return this.varNames[i];
    }

    public String[] variableNames() {
        return this.varNames;
    }

    public String[] parameterNames() {
        return this.parNames;
    }

    public int indexOfParameter(String name) {
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            if (!name.equals(this.parNames[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Function does not have variable named \"" + name + "\"");
    }

    public void setParameters(double[] params) {
        this.normalizationValid = false;
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            this.p[i] = params[i];
        }
    }

    public void setParameter(String name, double x) throws IllegalArgumentException {
        this.normalizationValid = false;
        this.p[this.indexOfParameter((String)name)] = x;
    }

    public double[] parameters() {
        return this.p;
    }

    public double parameter(String name) {
        return this.p[this.indexOfParameter(name)];
    }

    public boolean isEqual(IFunction f) {
        throw new UnsupportedOperationException("This method is not implemented yet");
    }

    public boolean providesGradient() {
        return this.providesGradient;
    }

    public double[] gradient(double[] x) {
        return this.gradient;
    }

    public String codeletString() {
        return this.codeletString;
    }

    public void setCodeletString(String codelet) {
        this.codeletString = codelet;
    }

    public void setDimension(int dim) {
        this.dimension = dim;
        this.x = new double[dim];
        if (dim != this.varNames.length) {
            this.varNames = new String[dim];
            this.min = new ArrayList[dim];
            this.max = new ArrayList[dim];
            for (int i = 0; i < dim; ++i) {
                this.min[i] = new ArrayList();
                this.max[i] = new ArrayList();
                this.varNames[i] = "x" + i;
            }
        }
    }

    public void setProvidesGradient(boolean yes) {
        this.providesGradient = yes;
    }

    public boolean setVariableNames(String[] names) {
        if (this.dimension != names.length) {
            throw new IllegalArgumentException("Number of parameters in the function (" + this.dimension + ") is not equal to the number of elements in array (" + names.length + ").");
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.varNames[i] = names[i];
        }
        return true;
    }

    public void setNumberOfParameters(int parnum) {
        this.p = new double[parnum];
        if (parnum != this.parNames.length) {
            this.parNames = new String[parnum];
        }
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            this.parNames[i] = "p" + i;
        }
    }

    public boolean setParameterNames(String[] names) {
        if (this.numberOfParameters() != names.length) {
            throw new IllegalArgumentException("Number of parameters in the function (" + this.numberOfParameters() + ") is not equal to the number of elements in array (" + names.length + ").");
        }
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            this.parNames[i] = names[i];
        }
        return true;
    }

    public void setAnnotation(IAnnotation ptr) {
        this.annotation = ptr;
    }

    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    public void normalize(boolean on) {
        if (on && !this.isNormalized && this.providesNormalization) {
            this.normalizationAmplitude = this.normalizationAmplitude();
            this.isNormalized = true;
        }
    }

    public boolean isNormalized() {
        return this.isNormalized;
    }

    public double[] parameterGradient(double[] x) {
        return this.parameterGradient;
    }

    public boolean providesParameterGradient() {
        return this.providesParameterGradient;
    }

    public void setNormalizationRange(double rMin, double rMax, int iAxis) {
        this.normalizationValid = false;
        this.min = new ArrayList[this.dimension];
        this.max = new ArrayList[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.min[i] = new ArrayList();
            this.max[i] = new ArrayList();
        }
        this.min[iAxis].add(new Double(rMin));
        this.max[iAxis].add(new Double(rMax));
    }

    public void includeNormalizationRange(double xMin, double xMax, int iAxis) {
        this.normalizationValid = false;
        this.min[iAxis].add(new Double(xMin));
        this.max[iAxis].add(new Double(xMax));
    }

    public void excludeNormalizationRange(double xMin, double xMax, int iAxis) {
        this.normalizationValid = false;
    }

    public void includeNormalizationAll(int iAxis) {
        this.normalizationValid = false;
    }

    public void excludeNormalizationAll(int iAxis) {
        this.normalizationValid = false;
    }

    public void includeNormalizationAll() {
        this.normalizationValid = false;
    }

    public void excludeNormalizationAll() {
        this.normalizationValid = false;
    }

    public IRangeSet normalizationRange(int iAxis) {
        return this.rangeSet[iAxis];
    }

    public boolean setNormalization(boolean provides, boolean is_normalized) {
        if (!provides && is_normalized) {
            throw new IllegalArgumentException("Function can not be \"normalized\" and not provide normalization at the same time");
        }
        this.providesNormalization = provides;
        this.isNormalized = is_normalized;
        return true;
    }

    public void setProvidesParameterGradient(boolean yes) {
        this.providesParameterGradient = yes;
    }

    public final double normalizationAmplitude() {
        return this.normalizationAmplitude(this.min, this.max);
    }

    public double normalizationAmplitude(ArrayList[] xMin, ArrayList[] xMax) {
        return 1.0;
    }

    public String title() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }
}

