/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnalysisFactory;
import hep.aida.IAnnotation;
import hep.aida.IBaseHistogram;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.IPlotter;
import hep.aida.IRangeSet;
import hep.aida.ITree;
import hep.aida.ref.Annotation;
import hep.aida.ref.function.FunctionChangedEvent;
import hep.aida.ref.function.FunctionDispatcher;
import hep.aida.ref.function.FunctionListener;
import hep.aida.ref.function.FunctionUtils;
import hep.aida.ref.function.RangeSet;
import java.util.ArrayList;
import java.util.Random;

public abstract class AbstractIFunction
implements IModelFunction,
FunctionDispatcher {
    protected String[] variableNames;
    protected String[] parameterNames;
    protected String codeletString;
    private Annotation annotation;
    private int dimension;
    private int numberOfParameters;
    private ArrayList listeners = new ArrayList();
    private RangeSet[] rangeSet;
    protected double[] p;
    protected double[] gradient;

    public AbstractIFunction(String title, int dimension, int numberOfParameters) {
        int i;
        this.variableNames = new String[dimension];
        for (i = 0; i < dimension; ++i) {
            this.variableNames[i] = "x" + i;
        }
        this.parameterNames = new String[numberOfParameters];
        for (i = 0; i < numberOfParameters; ++i) {
            this.parameterNames[i] = "p" + i;
        }
        this.init(title);
    }

    public AbstractIFunction(String title, String[] variableNames, String[] parameterNames) {
        this.variableNames = variableNames;
        this.parameterNames = parameterNames;
        this.init(title);
    }

    protected void init(String title) {
        this.dimension = this.variableNames.length;
        this.numberOfParameters = this.parameterNames.length;
        this.p = new double[this.numberOfParameters];
        this.gradient = new double[this.dimension];
        this.rangeSet = new RangeSet[this.dimension()];
        for (int i = 0; i < this.dimension(); ++i) {
            this.rangeSet[i] = new RangeSet();
        }
        this.codeletString = "codelet:hep.aida.ref.function.AbstractIFunction:file:";
        if (title == null) {
            title = "";
        }
        this.annotation = new Annotation();
        this.annotation.addItem(Annotation.titleKey, title);
        this.annotation.setFillable(true);
    }

    public void setCodeletString(String str) {
        this.codeletString = str;
    }

    public abstract double value(double[] var1);

    public boolean providesGradient() {
        return false;
    }

    public double[] gradient(double[] values) {
        return this.gradient;
    }

    public String codeletString() {
        return this.codeletString;
    }

    public IAnnotation annotation() {
        return this.annotation;
    }

    public int dimension() {
        return this.dimension;
    }

    public int indexOfParameter(String str) {
        int index = -1;
        for (int i = 0; i < this.numberOfParameters; ++i) {
            if (!str.equals(this.parameterNames[i])) continue;
            index = i;
            break;
        }
        return index;
    }

    public int numberOfParameters() {
        return this.numberOfParameters;
    }

    public double parameter(String str) {
        int index = this.indexOfParameter(str);
        if (index == -1) {
            throw new IllegalArgumentException("Parameter \"" + str + "\" does not exist");
        }
        return this.p[index];
    }

    public String[] parameterNames() {
        return this.parameterNames;
    }

    public double[] parameters() {
        return this.p;
    }

    public void setParameter(String str, double param) throws IllegalArgumentException {
        int index = this.indexOfParameter(str);
        if (index == -1) {
            throw new IllegalArgumentException("Parameter \"" + str + "\" does not exist");
        }
        this.p[index] = param;
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.PARAMETER_VALUE_CHANGED));
    }

    public void setParameters(double[] pars) throws IllegalArgumentException {
        if (pars.length != this.numberOfParameters) {
            throw new IllegalArgumentException("Wrong number of input parameters:" + pars.length + ", must be " + this.numberOfParameters);
        }
        for (int i = 0; i < this.numberOfParameters; ++i) {
            this.p[i] = pars[i];
        }
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.PARAMETER_VALUE_CHANGED));
    }

    public void setTitle(String title) throws IllegalArgumentException {
        this.annotation.setValue(Annotation.titleKey, title);
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.TITLE_CHANGED));
    }

    public String title() {
        return this.annotation.value(Annotation.titleKey);
    }

    public String variableName(int index) {
        return this.variableNames[index];
    }

    public String[] variableNames() {
        return this.variableNames;
    }

    public void excludeNormalizationAll() {
        for (int i = 0; i < this.dimension(); ++i) {
            this.rangeSet[i].excludeAll();
        }
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.RANGE_CHANGED));
    }

    public void includeNormalizationAll() {
        for (int i = 0; i < this.dimension(); ++i) {
            this.rangeSet[i].includeAll();
        }
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.RANGE_CHANGED));
    }

    public boolean isNormalized() {
        return false;
    }

    public IRangeSet normalizationRange(int iAxis) {
        return this.rangeSet[iAxis];
    }

    public void normalize(boolean param) {
    }

    public double[] parameterGradient(double[] values) {
        return null;
    }

    public boolean providesNormalization() {
        return false;
    }

    public boolean providesParameterGradient() {
        return false;
    }

    public String normalizationParameter() {
        throw new UnsupportedOperationException("This method needs to be overwritten to perform unbinned fits");
    }

    public boolean isEqual(IFunction iFunction) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static void main(String[] args) {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        IFitFactory fitFactory = af.createFitFactory();
        tree.mkdir("/Histograms");
        tree.cd("/Histograms");
        IHistogram1D h1 = hf.createHistogram1D("Histogram-1", 50, -3.0, 3.0);
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            double x = r.nextGaussian() * 2.0 + 1.0;
            h1.fill(x);
        }
        AbstractIFunction f1 = new AbstractIFunction("Parabola", 1, 3){

            public double value(double[] v) {
                return this.p[0] * v[0] * v[0] + this.p[1] * v[0] + this.p[2];
            }
        };
        f1.setParameters(new double[]{-3.0, -2.0, 30.0});
        IFitter fitter = fitFactory.createFitter("Chi2", "uncmin", "noClone=\"true\"");
        IFitResult fitResult = fitter.fit((IBaseHistogram)h1, (IFunction)f1);
        IHistogram1D h2 = hf.createHistogram1D("Histogram-2", 50, -3.0, 3.0);
        AbstractIFunction f2 = new AbstractIFunction("Parabola", 1, 3){

            public double value(double[] v) {
                return this.p[0] * v[0] * v[0] + this.p[1] * v[0] + this.p[2];
            }
        };
        f2.setParameters(new double[]{1.0, -4.0, 4.0});
        FunctionUtils.fill(h2, (IFunction)f2, 10000, 20.0);
        IPlotter plotter = af.createPlotterFactory().create("Test Fit plot");
        plotter.show();
        plotter.createRegions(1, 2);
        plotter.region(0).plot((IBaseHistogram)h1);
        plotter.region(0).plot(fitResult.fittedFunction());
        plotter.region(1).plot((IBaseHistogram)h2);
        System.out.println("Chi2=" + fitResult.quality());
    }

    public void addFunctionListener(FunctionListener listener) {
        this.listeners.add(listener);
    }

    public void removeFunctionListener(FunctionListener listener) {
        this.listeners.remove(listener);
    }

    void notifyFunctionChanged(FunctionChangedEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FunctionListener)this.listeners.get(i)).functionChanged(event);
        }
    }
}

