/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.hbook;

import hep.aida.ITuple;
import hep.aida.ref.tuple.ReadOnlyAbstractTuple;
import hep.io.hbook.ColumnwiseTuple;
import hep.io.hbook.ColumnwiseTupleColumn;
import org.freehep.util.Value;

class HBookColumnwiseTuple
extends ReadOnlyAbstractTuple {
    private ColumnwiseTuple tuple;
    private ColumnwiseTupleColumn[] columns;

    HBookColumnwiseTuple(ColumnwiseTuple tuple) {
        super(String.valueOf(tuple.id()), tuple.getName());
        this.tuple = tuple;
        int nCols = tuple.nChildren();
        this.columns = new ColumnwiseTupleColumn[nCols];
        for (int i = 0; i < nCols; ++i) {
            this.columns[i] = (ColumnwiseTupleColumn)tuple.getChild(i);
        }
    }

    public double columnMax(int column) throws IllegalArgumentException {
        return this.columns[column].getMax();
    }

    public double columnMean(int column) throws IllegalArgumentException {
        return Double.NaN;
    }

    public double columnMin(int column) throws IllegalArgumentException {
        return this.columns[column].getMin();
    }

    public String columnName(int column) throws IllegalArgumentException {
        return this.columns[column].getName();
    }

    public double columnRms(int column) throws IllegalArgumentException {
        return Double.NaN;
    }

    public Class columnType(int column) throws IllegalArgumentException {
        return this.columns[column].getColumnClass();
    }

    public int columns() {
        return this.columns.length;
    }

    public int findColumn(String name) throws IllegalArgumentException {
        int index = this.tuple.getIndex(name);
        if (index < 0) {
            throw new IllegalArgumentException("Column " + name + " does not exist");
        }
        return index;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public boolean isInMemory() {
        return true;
    }

    public boolean providesColumnDefaultValues() {
        return false;
    }

    public void columnValue(int column, Value v) {
        Class type = this.columnType(column);
        ColumnwiseTupleColumn child = this.columns[column];
        if (type == Integer.TYPE) {
            v.set(child.getInt());
        } else if (type == Short.TYPE) {
            v.set((short)child.getInt());
        } else if (type == Long.TYPE) {
            v.set(child.getInt());
        } else if (type == Float.TYPE) {
            v.set((float)child.getDouble());
        } else if (type == Double.TYPE) {
            v.set(child.getDouble());
        } else if (type == Boolean.TYPE) {
            v.set(child.getBoolean());
        } else if (type == Byte.TYPE) {
            v.set((byte)child.getInt());
        } else if (type == Character.TYPE) {
            v.set((char)child.getInt());
        } else if (type == String.class) {
            v.set(child.getString());
        } else {
            v.set((Object)child.getObject());
        }
    }

    public ITuple findTuple(int param) {
        throw new UnsupportedOperationException();
    }

    public boolean next() {
        boolean advanced = super.next();
        if (advanced) {
            this.tuple.setCurrentRow(this.getRow() + 1);
        }
        return advanced;
    }

    public int rows() {
        return this.tuple.getRows();
    }

    public void setRow(int row) throws IllegalArgumentException {
        super.setRow(row);
        this.tuple.setCurrentRow(row + 1);
    }

    public void skip(int n) throws IllegalArgumentException {
        super.skip(n);
        this.tuple.setCurrentRow(this.getRow() + 1);
    }

    public int columnIndexByName(String name) {
        return this.findColumn(name);
    }

    public String columnDefaultString(int index) {
        throw new UnsupportedOperationException();
    }

    public Object columnDefaultValue(int index) {
        throw new UnsupportedOperationException();
    }
}

