/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import cern.colt.function.DoubleFunction;
import cern.jet.math.Functions;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.Variable;
import hep.aida.ref.pdf.VariableList;

public class Gaussian
extends Function {
    private Dependent x;
    private Parameter m;
    private Parameter s;
    private final double r2 = Math.sqrt(2.0);
    private final double rootPiOverTwo = Math.sqrt(1.5707963267948966);
    private double twoSigmaSquared;
    private double mean;
    private double sigma;
    private double xVal;
    private static DoubleFunction erf = Functions.erf;

    public Gaussian(String name) {
        this(name, null, null, null);
    }

    public Gaussian(String name, Dependent x) {
        this(name, x, null, null);
    }

    public Gaussian(String name, Dependent x, Parameter mean, Parameter sigma) {
        super(name);
        this.x = x;
        this.m = mean;
        this.s = sigma;
        this.initializeVariables();
    }

    private void initializeVariables() {
        if (this.x == null) {
            this.x = new Dependent("x", -10.0, 10.0);
        }
        if (this.m == null) {
            this.m = new Parameter("mean");
        }
        if (this.s == null) {
            this.s = new Parameter("sigma");
        }
        VariableList list = new VariableList();
        list.add(this.x);
        list.add(this.m);
        list.add(this.s);
        this.addVariables(list);
    }

    public void variableChanged(Variable var) {
        if (var == this.m) {
            this.mean = this.m.value();
        } else if (var == this.s) {
            this.sigma = this.s.value();
            this.twoSigmaSquared = 2.0 * Math.pow(this.sigma, 2.0);
        } else if (var == this.x) {
            this.xVal = this.x.value();
        }
    }

    public double functionMaxValue() {
        return 1.0;
    }

    public double functionValue() {
        return Math.exp(-Math.pow(this.xVal - this.mean, 2.0) / this.twoSigmaSquared);
    }

    public double evaluateAnalyticalVariableGradient(Variable var) {
        double y = this.functionValue();
        if (var == this.x) {
            return y * -2.0 * (this.xVal - this.mean) / this.twoSigmaSquared;
        }
        if (var == this.m) {
            return y * 2.0 * (this.xVal - this.mean) / this.twoSigmaSquared;
        }
        if (var == this.s) {
            return y * 2.0 * Math.pow(this.xVal - this.mean, 2.0) / (this.twoSigmaSquared * this.sigma);
        }
        return 0.0;
    }

    public boolean hasAnalyticalVariableGradient(Variable var) {
        return true;
    }

    public boolean hasAnalyticalNormalization(Dependent dep) {
        return dep == this.x;
    }

    public double evaluateAnalyticalNormalization(Dependent dep) {
        double[] xMax = this.x.range().upperBounds();
        double[] xMin = this.x.range().lowerBounds();
        if (xMax.length != 1 || xMin.length != 1) {
            throw new IllegalArgumentException("Normalization over multiple ranges is not supported for Function Gaussian.");
        }
        double den = this.r2 * this.sigma;
        double ue = erf.apply((xMax[0] - this.mean) / den);
        double le = erf.apply((xMin[0] - this.mean) / den);
        return this.rootPiOverTwo * this.sigma * (ue - le);
    }
}

