/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.styleEditor;

import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import hep.aida.IAnalysisFactory;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.styleEditor.ConfigurePreviewPanel;
import hep.aida.ref.plotter.styleEditor.StyleEditorPanel;
import hep.aida.ref.plotter.styleEditor.StylePreviewCreator;
import hep.aida.ref.xml.AidaStyleXMLReader;
import hep.aida.ref.xml.AidaStyleXMLWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class AidaStyleEditor
extends JFrame {
    JFrame frame;
    private JTabbedPane tabbedPanel;
    private Class previewType;
    private ConfigurePreviewPanel configurePanel;
    private JFileChooser inputChooser = new JFileChooser();
    private JTextField outputFile = new JTextField(30);
    private JCheckBox writeSetParameters = new JCheckBox("Write Only Set Parameters");
    private JFileChooser outputChooser = new JFileChooser();
    private JPanel outputPanel;
    private JButton outputBrowse;
    private int newStyleCounter = 0;
    private Hashtable files = new Hashtable();
    private Image homeImage;
    private JPanel homePanel;
    private Logger styleLogger = Logger.getLogger("hep.aida.ref.plotter.styleEditor");
    private Level logLevel = Level.INFO;

    public static void setLoggerLevel(Logger logger, Level l) {
        final String lineSeparator = System.getProperty("line.separator", "\n");
        logger.setLevel(l);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(l);
            handlers[index].setFormatter(new SimpleFormatter(){

                public String format(LogRecord record) {
                    long millis = record.getMillis() % 1000L;
                    String tmp = super.format(record);
                    tmp = tmp.replaceFirst(lineSeparator, " [" + millis + "] :: \t");
                    return tmp;
                }
            });
        }
        logger.fine("Set verbose level to: " + logger.getLevel());
    }

    public AidaStyleEditor() {
        this("AIDA Style Editor");
    }

    public AidaStyleEditor(String frameName) {
        super(frameName);
        AidaStyleEditor.setLoggerLevel(this.styleLogger, this.logLevel);
        this.frame = this;
        this.init();
        this.pack();
        this.setSize(700, 600);
        this.addHomePage();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    private void init() {
        this.tabbedPanel = new JTabbedPane();
        this.configurePanel = new ConfigurePreviewPanel();
        this.createMenus();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.tabbedPanel);
        this.setDefaultCloseOperation(3);
    }

    private void createMenus() {
        JMenu fileMenu = new JMenu("File");
        JMenuItem item = new JMenuItem("New Style");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AidaStyleEditor.this.newStyleAction();
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Open Style...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AidaStyleEditor.this.readStyleAction();
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Save Style As...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AidaStyleEditor.this.saveStyleAsAction();
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Close Style");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AidaStyleEditor.this.removeSelectedTabAction();
            }
        });
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem("Exit");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AidaStyleEditor.this.exitAction();
            }
        });
        fileMenu.add(item);
        JMenu viewMenu = new JMenu("View");
        JMenu previewMenu = new JMenu("Set Preview Type");
        viewMenu.add(previewMenu);
        JRadioButtonMenuItem rbItem = null;
        ButtonGroup rbGroup = new ButtonGroup();
        Class[] possibleTypes = StylePreviewCreator.getPossiblePreviewTypes();
        ActionListener typeListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AidaStyleEditor.this.setPreviewTypeAction(evt.getActionCommand());
            }
        };
        for (int i = 0; i < possibleTypes.length; ++i) {
            rbItem = new JRadioButtonMenuItem(possibleTypes[i].getName());
            rbItem.addActionListener(typeListener);
            rbGroup.add(rbItem);
            previewMenu.add(rbItem);
        }
        ((JRadioButtonMenuItem)rbGroup.getElements().nextElement()).setSelected(true);
        this.previewType = possibleTypes[0];
        item = new JMenuItem("Configure Preview...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AidaStyleEditor.this.configurePreviewAction();
            }
        });
        viewMenu.add(item);
        viewMenu.addSeparator();
        VerboseMenu verboseMenu = new VerboseMenu();
        viewMenu.add(verboseMenu);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        this.setJMenuBar(menuBar);
        this.outputBrowse = new JButton("Browse...");
        this.outputBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = AidaStyleEditor.this.outputChooser.showOpenDialog(AidaStyleEditor.this.frame);
                if (returnVal == 0) {
                    File file = AidaStyleEditor.this.outputChooser.getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    AidaStyleEditor.this.outputFile.setText(fileName);
                }
            }
        });
        this.outputPanel = new JPanel();
        this.writeSetParameters.setSelected(true);
        this.outputPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.outputPanel.add((Component)new JLabel("Output File: "), gbc);
        gbc.gridx = 1;
        this.outputPanel.add((Component)this.outputFile, gbc);
        gbc.gridx = 2;
        this.outputPanel.add((Component)this.outputBrowse, gbc);
        gbc.gridy = 1;
        gbc.gridx = 1;
        this.outputPanel.add((Component)this.writeSetParameters, gbc);
    }

    void newStyleAction() {
        IPlotterStyle style = IAnalysisFactory.create().createPlotterFactory().createPlotterStyle();
        ++this.newStyleCounter;
        this.addTab("New Style " + this.newStyleCounter, style);
    }

    void saveStyleAsAction() {
        String title;
        int reply;
        StyleEditorPanel panel = this.getSelectedEditorPanel();
        int index = this.tabbedPanel.getSelectedIndex();
        if (panel == null) {
            this.styleLogger.info("No Tab is currently selected.");
            return;
        }
        File file = (File)this.files.get(panel);
        IPlotterStyle style = panel.getStyle();
        if (file != null) {
            this.outputFile.setText(file.getAbsolutePath());
            this.outputChooser.setCurrentDirectory(file.getParentFile());
        }
        if ((reply = JOptionPane.showOptionDialog(this.frame, this.outputPanel, title = "Select Output File", 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel")) == 0) {
            String fileName = this.outputFile.getText();
            boolean writeAll = !this.writeSetParameters.isSelected();
            try {
                this.styleLogger.fine("Writing: file=" + fileName + ", Style=" + style + ", writeAll=" + writeAll);
                AidaStyleXMLWriter.writeStyleToDisk(fileName, style, writeAll);
                if (file == null || !fileName.equals(file.getAbsoluteFile())) {
                    File newFile = new File(fileName);
                    if (file != null) {
                        this.files.remove(panel);
                    }
                    this.files.put(panel, newFile);
                    this.tabbedPanel.setTitleAt(index, newFile.getName());
                }
            }
            catch (Exception e) {
                this.styleLogger.info("Can not write style to file: " + fileName);
                this.styleLogger.log(Level.FINE, "", e);
            }
        } else {
            return;
        }
    }

    void readStyleAction() {
        File file = null;
        String fileName = null;
        int returnVal = this.inputChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        file = this.inputChooser.getSelectedFile();
        fileName = file.getAbsolutePath();
        try {
            IPlotterStyle style = AidaStyleXMLReader.restoreStyleFromFile(fileName);
            StyleEditorPanel panel = this.addTab(file.getName(), style);
            this.files.put(panel, file);
        }
        catch (Exception e) {
            this.styleLogger.info("Can not edit style from file: " + fileName);
            this.styleLogger.log(Level.FINE, "", e);
        }
    }

    void setPreviewTypeAction(String type) {
        try {
            this.previewType = Class.forName(type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StyleEditorPanel panel = this.getSelectedEditorPanel();
        if (panel == null) {
            return;
        }
        panel.setPreviewType(this.previewType);
    }

    StyleEditorPanel getSelectedEditorPanel() {
        StyleEditorPanel panel = null;
        Component comp = this.tabbedPanel.getSelectedComponent();
        if (comp instanceof StyleEditorPanel) {
            panel = (StyleEditorPanel)comp;
        }
        return panel;
    }

    void configurePreviewAction() {
        StyleEditorPanel panel = this.getSelectedEditorPanel();
        String title = "Configure Preview Dialog";
        boolean wrong = true;
        while (wrong) {
            int reply = JOptionPane.showOptionDialog(this.frame, this.configurePanel, title, 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel");
            if (reply == 0) {
                try {
                    this.configurePanel.validateInput();
                    this.configurePanel.readInput();
                    if (panel != null) {
                        panel.setupEditorPanel(this.configurePanel);
                    }
                    wrong = false;
                }
                catch (NumberFormatException e) {
                    String message = "Wrong input! Please correct: ";
                    message = message + "\n" + e.getMessage();
                    JOptionPane.showMessageDialog(this.frame, message, "Wrong Input", -1);
                }
                continue;
            }
            this.configurePanel.resetPanel();
            wrong = false;
        }
    }

    StyleEditorPanel addTab(String title, IPlotterStyle style) {
        StyleEditorPanel panel = null;
        try {
            panel = new StyleEditorPanel(style, this.configurePanel, this.previewType);
            this.tabbedPanel.addTab(title, null, panel, "To Save style or Close selected tab use File menu");
            this.tabbedPanel.setSelectedComponent(panel);
        }
        catch (Exception e) {
            this.styleLogger.info("**** Problem with initial setup of Preview Panel Size: " + e.getMessage());
            this.styleLogger.log(Level.FINE, "", e);
        }
        return panel;
    }

    void removeSelectedTabAction() {
        StyleEditorPanel panel = this.getSelectedEditorPanel();
        if (panel == null) {
            this.styleLogger.fine("No Tab is currently selected.");
            return;
        }
        this.tabbedPanel.remove(panel);
        this.files.remove(panel);
        panel.clear();
    }

    void exitAction() {
        System.exit(1);
    }

    private void addHomePage() {
        if (this.homeImage == null) {
            URL url = this.getClass().getResource("images/homePageImage.png");
            this.homeImage = Toolkit.getDefaultToolkit().getImage(url);
        }
        if (this.homePanel == null) {
            this.homePanel = new JPanel(){

                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.drawImage(AidaStyleEditor.this.homeImage, 0, 0, this.getWidth(), this.getHeight(), this);
                }
            };
            JPanel p2 = new JPanel();
            p2.setMinimumSize(new Dimension(60, 200));
            p2.setBackground(Color.WHITE);
            GridLayout grid = new GridLayout(1, 2);
            grid.setHgap(10);
            p2.setLayout(grid);
            JButton newStyleButton = new JButton("New Style");
            newStyleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AidaStyleEditor.this.newStyleAction();
                }
            });
            JButton openStyleButton = new JButton("Open Style");
            openStyleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AidaStyleEditor.this.readStyleAction();
                }
            });
            p2.add(newStyleButton);
            p2.add(openStyleButton);
            this.homePanel.setLayout(new FlowLayout(1));
            this.homePanel.add((Component)p2, "Last");
            this.homePanel.setBackground(Color.WHITE);
        }
        this.tabbedPanel.addTab("Home", this.homePanel);
        this.tabbedPanel.setSelectedComponent(this.homePanel);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        LookAndFeelTweaks.tweak();
        LookAndFeelAddons addon = LookAndFeelAddons.getAddon();
        AidaStyleEditor editor = new AidaStyleEditor();
    }

    public class VerboseMenu
    extends JMenu
    implements ActionListener {
        public VerboseMenu() {
            this("Set Verbose Level", Level.INFO);
        }

        public VerboseMenu(String name) {
            this(name, Level.INFO);
        }

        public VerboseMenu(String name, Level startLevel) {
            super(name);
            AidaStyleEditor.setLoggerLevel(AidaStyleEditor.this.styleLogger, startLevel);
            ButtonGroup group = new ButtonGroup();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("Not Verbose");
            item.setMnemonic('N');
            item.addActionListener(this);
            group.add(item);
            this.add(item);
            if (startLevel == Level.SEVERE) {
                item.setSelected(true);
            }
            item = new JRadioButtonMenuItem("Verbose");
            item.setMnemonic('V');
            item.addActionListener(this);
            group.add(item);
            this.add(item);
            if (startLevel == Level.INFO) {
                item.setSelected(true);
            }
            item = new JRadioButtonMenuItem("Very Verbose");
            item.setMnemonic('W');
            item.addActionListener(this);
            group.add(item);
            this.add(item);
            if (startLevel == Level.FINE) {
                item.setSelected(true);
            }
            item = new JRadioButtonMenuItem("Debug");
            item.setMnemonic('D');
            item.addActionListener(this);
            this.add(item);
            group.add(item);
            if (startLevel == Level.FINEST) {
                item.setSelected(true);
            }
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("Not Verbose")) {
                AidaStyleEditor.setLoggerLevel(AidaStyleEditor.this.styleLogger, Level.SEVERE);
            } else if (command.equals("Verbose")) {
                AidaStyleEditor.setLoggerLevel(AidaStyleEditor.this.styleLogger, Level.INFO);
            } else if (command.equals("Very Verbose")) {
                AidaStyleEditor.setLoggerLevel(AidaStyleEditor.this.styleLogger, Level.FINE);
            } else if (command.equals("Debug")) {
                AidaStyleEditor.setLoggerLevel(AidaStyleEditor.this.styleLogger, Level.FINEST);
            }
        }
    }
}

