/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.styleEditor;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import hep.aida.IBaseStyle;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.styleEditor.StylePropertyEditorRegistry;
import hep.aida.ref.plotter.styleEditor.StylePropertyTableModel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class StyleTreeNode
implements TreeNode {
    private IBaseStyle style;
    private TreePath path;
    private PropertySheetPanel stylePanel;
    private JScrollPane scrollPanel;
    private Vector children;
    private int nChildren;
    private boolean recursive;
    private boolean hasBeenFilled = false;
    private StyleTreeNode parent;
    private TreePath parentPath;

    public StyleTreeNode(IPlotterStyle style) {
        this(style, true);
    }

    public StyleTreeNode(IPlotterStyle style, boolean recursive) {
        this((IBaseStyle)style, null, null, recursive);
    }

    public StyleTreeNode(IBaseStyle style, StyleTreeNode parent, TreePath parentPath) {
        this(style, parent, parentPath, true);
    }

    public StyleTreeNode(IBaseStyle style, StyleTreeNode parent, TreePath parentPath, boolean recursive) {
        this.style = style;
        this.parent = parent;
        this.parentPath = parentPath;
        this.path = parentPath == null ? new TreePath(style.name()) : parentPath.pathByAddingChild(style.name());
        this.createChildren();
        this.createPanel();
    }

    public String toString() {
        return this.style.name();
    }

    public IBaseStyle getStyle() {
        return this.style;
    }

    public JComponent getStylePanel() {
        return this.stylePanel;
    }

    public JComponent getScrollPanel() {
        return this.scrollPanel;
    }

    private void createChildren() {
        IBaseStyle[] ch = this.style.children();
        if (ch == null || ch.length == 0) {
            this.nChildren = 0;
            this.children = new Vector();
            this.hasBeenFilled = true;
            return;
        }
        this.nChildren = ch.length;
        if (this.recursive) {
            this.fillChildren();
        }
    }

    private void fillChildren() {
        IBaseStyle[] ch = this.style.children();
        if (this.children == null) {
            this.children = new Vector();
        }
        for (int i = 0; i < ch.length; ++i) {
            StyleTreeNode childNode = new StyleTreeNode(ch[i], this, this.path, this.recursive);
            this.children.add(childNode);
        }
        this.hasBeenFilled = true;
    }

    private void createPanel() {
        PropertySheetTable pt = new PropertySheetTable((PropertySheetTableModel)new StylePropertyTableModel(this.style));
        pt.setEditorFactory((PropertyEditorFactory)new StylePropertyEditorRegistry());
        this.stylePanel = new PropertySheetPanel(pt);
        this.stylePanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.path.toString()));
        this.scrollPanel = new JScrollPane((Component)this.stylePanel);
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Property prop = (Property)evt.getSource();
                prop.writeToObject((Object)StyleTreeNode.this.style);
            }
        };
        this.stylePanel.addPropertySheetChangeListener(listener);
    }

    public Enumeration children() {
        if (!this.hasBeenFilled) {
            this.fillChildren();
        }
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return this.nChildren > 0;
    }

    public TreeNode getChildAt(int childIndex) {
        if (!this.hasBeenFilled) {
            this.fillChildren();
        }
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.nChildren;
    }

    public int getIndex(TreeNode node) {
        if (!this.hasBeenFilled) {
            this.fillChildren();
        }
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.nChildren == 0;
    }
}

