/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.DVResolver;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import hep.aida.ITuple;
import hep.aida.ref.tuple.JELTupleProvider;
import java.util.Date;

class JELExpression {
    private String expression;
    private Object[] context;
    private Library lib;
    private CompiledExpression compExpression;

    protected JELExpression(String expression) {
        this.expression = expression;
    }

    protected String expression() {
        return this.expression;
    }

    protected double evaluateDouble() {
        try {
            return this.compExpression.evaluate_double(this.context);
        }
        catch (Throwable t) {
            throw new RuntimeException("Runtime JEL Evaluation Problems!", t);
        }
    }

    protected boolean evaluateBoolean() {
        try {
            return this.compExpression.evaluate_boolean(this.context);
        }
        catch (Throwable t) {
            throw new RuntimeException("Runtime JEL Evaluation Problems!", t);
        }
    }

    protected void compile(Class type, ITuple tuple) {
        this.lib = null;
        this.compExpression = null;
        Class[] staticLib = new Class[1];
        Class[] dynamicLib = new Class[1];
        this.context = new Object[1];
        Class[] dotLib = new Class[]{Object.class, String.class, Date.class};
        JELTupleProvider tupleProvider = new JELTupleProvider(tuple);
        try {
            staticLib[0] = Class.forName("java.lang.Math");
            this.context[0] = tupleProvider;
            dynamicLib[0] = ((Object)((Object)tupleProvider)).getClass();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can not find class for JEL!", e);
        }
        try {
            this.lib = new Library(staticLib, dynamicLib, dotLib, (DVResolver)tupleProvider, null);
            this.lib.markStateDependent("random", null);
        }
        catch (CompilationException ec1) {
            throw new RuntimeException("Can not compile JEL Library!", ec1);
        }
        try {
            this.compExpression = Evaluator.compile((String)this.expression, (Library)this.lib, (Class)type);
        }
        catch (CompilationException ec2) {
            throw new RuntimeException("Can not compile JEL Expression: " + this.expression, ec2);
        }
    }
}

