/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.IBaseTupleColumn;
import hep.aida.ITuple;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.tuple.AbstractTuple;
import hep.aida.ref.tuple.FTupleCursor;
import hep.aida.ref.tuple.TupleColumn;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.freehep.util.Value;

public class Tuple
extends AbstractTuple {
    protected static final int COLUMN_ROWS = 1000;
    private int columnLength;
    private int columnMaxLength;
    private String tupColumnsString = "";
    private int startRow = 0;
    private int endRow = -1;
    private int filledRows = 0;
    private Map optionMap;
    private String[] columnDefaultValues;
    private ArrayList tupleColumns = new ArrayList();
    private ArrayList folderList = new ArrayList();
    private Hashtable columnCounters = new Hashtable();
    private Value tupleValue = new Value();
    static /* synthetic */ Class class$java$lang$String;

    public Tuple(String name, String title, String[] columnName, Class[] columnType, String options) {
        super(name, title, options);
        this.initTuple(name, title, columnName, columnType, options);
    }

    public Tuple(String name, String title, String columnsString, String options) {
        super(name, title, options);
        this.initTuple(name, title, columnsString, options);
    }

    private void initTuple(String name, String title, String columnsString, String options) {
        this.setTitle(title);
        this.tupColumnsString = columnsString;
        this.optionMap = AidaUtils.parseOptions(options);
        StringTokenizer strT = new StringTokenizer(columnsString, ",;");
        int bracketCounter = 0;
        int nCol = 0;
        while (strT.hasMoreTokens()) {
            String token = strT.nextToken();
            if (bracketCounter == 0) {
                ++nCol;
            }
            if (token.indexOf("{") > 0) {
                ++bracketCounter;
            }
            if (token.indexOf("}") <= 0) continue;
            --bracketCounter;
        }
        if (nCol < 1) {
            throw new IllegalArgumentException("Cannot build Tuple with no columns\n");
        }
        StringTokenizer st = new StringTokenizer(columnsString, ",;");
        boolean columnIndex = false;
        bracketCounter = 0;
        String iTupleColString = "";
        String type = "";
        int colDefCount = 0;
        this.columnDefaultValues = new String[nCol];
        while (st.hasMoreTokens()) {
            String colName;
            String token = st.nextToken();
            token.trim();
            if (token.indexOf("{") > 0) {
                ++bracketCounter;
            }
            if (token.indexOf("}") > 0) {
                --bracketCounter;
            }
            iTupleColString = iTupleColString + token;
            if (st.hasMoreTokens()) {
                iTupleColString = iTupleColString + ";";
            }
            if (bracketCounter != 0) continue;
            String defaultValue = "";
            int brPos = (iTupleColString = iTupleColString.trim()).indexOf("{");
            if (brPos > 0) {
                iTupleColString.trim();
                int pos = iTupleColString.indexOf("(");
                if (pos > 0 && pos < brPos) {
                    type = iTupleColString.substring(0, pos).trim();
                    colName = iTupleColString.substring(iTupleColString.indexOf(")") + 1, brPos).trim();
                    if (colName.endsWith("=")) {
                        colName = colName.substring(0, colName.length() - 1).trim();
                    }
                    defaultValue = defaultValue + iTupleColString.substring(pos + 1, iTupleColString.indexOf(")")).trim();
                    defaultValue = defaultValue + iTupleColString.substring(brPos);
                } else {
                    int spPos = iTupleColString.indexOf(" ");
                    int eqPos = iTupleColString.indexOf("=");
                    type = iTupleColString.substring(0, spPos).trim();
                    colName = iTupleColString.substring(spPos + 1, eqPos).trim();
                    defaultValue = iTupleColString.substring(brPos).trim();
                }
            } else {
                StringTokenizer t = new StringTokenizer(token, "=");
                int tokens = t.countTokens();
                String nameAndType = t.nextToken().trim();
                if (tokens == 2) {
                    defaultValue = t.nextToken().trim();
                } else if (tokens != 1) {
                    throw new IllegalArgumentException("Wrong format " + token + "\n");
                }
                StringTokenizer tt = new StringTokenizer(nameAndType, " ");
                if (tt.countTokens() == 2) {
                    type = tt.nextToken().trim();
                }
                colName = tt.nextToken().trim();
            }
            Value value = new Value();
            Class colType = null;
            if (type.endsWith("ITuple")) {
                String defVal = defaultValue.substring(defaultValue.indexOf("{") + 1, defaultValue.lastIndexOf("}"));
                Tuple tup = new Tuple(colName, "", defVal, options);
                this.addTuple(tup);
                this.columnDefaultValues[colDefCount++] = defVal;
            } else {
                if (type.equals("int")) {
                    colType = Integer.TYPE;
                } else if (type.equals("short")) {
                    colType = Short.TYPE;
                } else if (type.equals("long")) {
                    colType = Long.TYPE;
                } else if (type.equals("float")) {
                    colType = Float.TYPE;
                } else if (type.equals("double")) {
                    colType = Double.TYPE;
                } else if (type.equals("boolean")) {
                    colType = Boolean.TYPE;
                } else if (type.equals("byte")) {
                    colType = Byte.TYPE;
                } else if (type.equals("char")) {
                    colType = Character.TYPE;
                } else if (type.equals("string")) {
                    colType = class$java$lang$String == null ? Tuple.class$("java.lang.String") : class$java$lang$String;
                } else {
                    try {
                        colType = Class.forName(type);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IllegalArgumentException("Unsupported type " + type);
                    }
                }
                this.fillDefaultValue(colType, defaultValue, value);
                TupleColumn fcolumn = TupleColumnFactory.createTupleColumn(colName, colType, value, options, this);
                this.addColumn(fcolumn);
                this.columnDefaultValues[colDefCount++] = defaultValue;
            }
            iTupleColString = "";
        }
        this.start();
    }

    private void initTuple(String name, String title, String[] columnName, Class[] columnType, String options) {
        this.setTitle(title);
        this.optionMap = AidaUtils.parseOptions(options);
        int colNames = columnName.length;
        int colTypes = columnType.length;
        if (colNames < 1) {
            throw new IllegalArgumentException("columnName cannot be empty\n");
        }
        if (colTypes < 1) {
            throw new IllegalArgumentException("columnType cannot be empty\n");
        }
        if (colNames != colTypes) {
            throw new IllegalArgumentException("The number of column names " + colNames + " is different than the number of column types " + colTypes + "\n");
        }
        int colDefCount = 0;
        this.columnDefaultValues = new String[colNames];
        for (int i = 0; i < colNames; ++i) {
            Class colType = columnType[i];
            String colName = "";
            String defaultValue = "";
            this.tupColumnsString = this.tupColumnsString + colType + " " + columnName[i];
            if (i < colNames) {
                this.tupColumnsString = this.tupColumnsString + ";";
            }
            Value value = new Value();
            if (colType == (class$hep$aida$ITuple == null ? Tuple.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                String iTupleString = columnName[i];
                int pos = iTupleString.indexOf(")");
                if (pos > 0) {
                    colName = iTupleString.substring(pos + 1, iTupleString.indexOf("{")).trim();
                    if (colName.endsWith("=")) {
                        colName = colName.substring(0, colName.length() - 1).trim();
                    }
                    defaultValue = defaultValue + iTupleString.substring(iTupleString.indexOf("(") + 1, pos);
                } else {
                    colName = iTupleString.indexOf("=") > 0 ? iTupleString.substring(0, iTupleString.indexOf("=")).trim() : iTupleString.trim();
                }
                if (iTupleString.indexOf("{") > 0) {
                    defaultValue = defaultValue + iTupleString.substring(iTupleString.indexOf("{"), iTupleString.lastIndexOf("}") + 1).trim();
                }
                String defVal = defaultValue.substring(defaultValue.indexOf("{") + 1, defaultValue.lastIndexOf("}"));
                Tuple tup = new Tuple(colName, "", defVal, options);
                this.addTuple(tup);
                this.columnDefaultValues[colDefCount++] = defVal;
                continue;
            }
            colName = columnName[i];
            StringTokenizer st = new StringTokenizer(colName, "=");
            colName = st.nextToken().trim();
            if (st.hasMoreTokens()) {
                defaultValue = st.nextToken().trim();
            }
            this.fillDefaultValue(colType, defaultValue, value);
            TupleColumn fcolumn = TupleColumnFactory.createTupleColumn(colName, colType, value, options, this);
            this.addColumn(fcolumn);
            this.columnDefaultValues[colDefCount++] = defaultValue;
        }
        this.start();
    }

    private String getColString() {
        return this.tupColumnsString;
    }

    private void fillDefaultValue(Class type, String defaultValue, Value value) {
        if (type == Integer.TYPE) {
            value.set(defaultValue.equals("") ? 0 : Integer.parseInt(defaultValue));
        } else if (type == Short.TYPE) {
            value.set(defaultValue.equals("") ? (short)0 : Short.parseShort(defaultValue));
        } else if (type == Long.TYPE) {
            value.set(defaultValue.equals("") ? 0L : Long.parseLong(defaultValue));
        } else if (type == Float.TYPE) {
            value.set(defaultValue.equals("") ? 0.0f : Float.parseFloat(defaultValue));
        } else if (type == Double.TYPE) {
            value.set(defaultValue.equals("") ? 0.0 : Double.parseDouble(defaultValue));
        } else if (type == Boolean.TYPE) {
            value.set(defaultValue.equals("") ? false : Boolean.valueOf(defaultValue));
        } else if (type == Byte.TYPE) {
            value.set(defaultValue.equals("") ? (byte)0 : Byte.parseByte(defaultValue));
        } else if (type == Character.TYPE) {
            value.set(defaultValue.equals("") ? (char)'\u0000' : defaultValue.charAt(0));
        } else {
            value.set(defaultValue);
        }
    }

    public String columnDefaultString(int column) {
        if (this.columnType(column) != ITuple.class) {
            return this.columnDefaultValues[column];
        }
        Tuple tup = (Tuple)this.findTuple(column);
        if (tup != null) {
            return "( " + tup.getOptions() + " ) " + tup.name() + " = {" + tup.getColString() + "}";
        }
        return "null";
    }

    public boolean providesColumnDefaultValues() {
        return true;
    }

    public ITuple findTuple(int index) {
        return this.getFolder(index, this.filledRows);
    }

    public void fill(int column, Value value) {
        this.tupleColumn(column).fill(value);
    }

    public void columnValue(int column, FTupleCursor cursor, Value value) {
        if (this.columnType(column) != ITuple.class) {
            this.tupleColumn(column).value(cursor, value);
        } else {
            value.set((Object)this.getFolder(column, cursor.row()));
        }
    }

    public void columnValue(int column, Value value) {
        if (this.columnType(column) != ITuple.class) {
            this.tupleColumn(column).value(this.internalCursor(), value);
        } else {
            value.set((Object)this.getFolder(column, this.internalCursor().row()));
        }
    }

    public boolean isInMemory() {
        return true;
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public void addRow() {
        for (int i = 0; i < this.columns(); ++i) {
            this.tupleColumn(i).addRow();
        }
        Enumeration keys = this.columnCounters.keys();
        while (keys.hasMoreElements()) {
            String folderName = (String)keys.nextElement();
            Tuple folder = this.getFolder(this.findColumn(folderName), this.filledRows);
            TupleColumn tc = (TupleColumn)this.columnCounters.get(folderName);
            tc.fill(this.tupleValue.set(folder.startRow() + folder.rows()));
            tc.addRow();
        }
        ++this.filledRows;
        this.newInternalCursor();
    }

    public void resetRow() {
        for (int i = 0; i < this.columns(); ++i) {
            ((TupleColumn)this.tupleColumns.get(i)).resetRow();
        }
        Enumeration keys = this.columnCounters.keys();
        while (keys.hasMoreElements()) {
            String folderName = (String)keys.nextElement();
            Tuple folder = this.getFolder(this.findColumn(folderName), this.filledRows);
            folder.resetRows(folder.rows());
            TupleColumn tc = (TupleColumn)this.columnCounters.get(folder.name());
            tc.resetRow();
        }
    }

    public void reset() {
        for (int i = 0; i < this.columns(); ++i) {
            ((TupleColumn)this.tupleColumns.get(i)).reset();
        }
        this.filledRows = 0;
        this.newInternalCursor();
    }

    public int rows() {
        if (this.endRow != -1) {
            return this.endRow - this.startRow;
        }
        return this.filledRows - this.startRow;
    }

    public int findColumn(String name) {
        for (int i = 0; i < this.columns(); ++i) {
            if (!this.columnName(i).equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("Column " + name + " does not exist\n");
    }

    public String columnName(int column) {
        return this.column(column).name();
    }

    public Class columnType(int column) {
        return this.column(column).type();
    }

    public double columnMin(int column) {
        this.tupleColumn(column).minValue(this.tupleValue);
        return this.tupleValue.getDouble();
    }

    public double columnMax(int column) {
        this.tupleColumn(column).maxValue(this.tupleValue);
        return this.tupleValue.getDouble();
    }

    public double columnMean(int column) {
        this.tupleColumn(column).meanValue(this.tupleValue);
        return this.tupleValue.getDouble();
    }

    public double columnRms(int column) {
        this.tupleColumn(column).rmsValue(this.tupleValue);
        return this.tupleValue.getDouble();
    }

    public int columns() {
        return this.tupleColumns.size();
    }

    int startRow() {
        return this.startRow;
    }

    void addColumn(TupleColumn column) {
        this.tupleColumns.add(column);
    }

    void removeColumn(TupleColumn column) {
        this.tupleColumns.remove(column);
    }

    void addTuple(Tuple tuple) {
        this.columnCounters.put(tuple.name(), TupleColumnFactory.createTupleColumn(tuple.name(), Integer.TYPE, new Value().set(0), "length=1000; maxlength=-1", this));
        this.addColumn(TupleColumnFactory.createTupleColumn(tuple.name(), ITuple.class, null, "", tuple));
        this.folderList.add(tuple);
    }

    void removeTuple(Tuple tuple) {
        String name = tuple.name();
        this.columnCounters.remove(name);
        TupleColumn col = (TupleColumn)this.column(name);
        this.removeColumn(col);
        this.folderList.remove(tuple);
    }

    private void setStartEndRow(int startRow, int endRow) {
        this.startRow = startRow;
        this.endRow = endRow;
    }

    private void resetRows(int numberOfRows) {
        for (int i = 0; i < this.columns(); ++i) {
            ((TupleColumn)this.tupleColumns.get(i)).resetRows(numberOfRows);
        }
        int cf = this.filledRows;
        this.filledRows -= numberOfRows;
        Enumeration keys = this.columnCounters.keys();
        while (keys.hasMoreElements()) {
            String folderName = (String)keys.nextElement();
            while (numberOfRows-- > 0) {
                Tuple folder = this.getFolder(this.findColumn(folderName), --cf);
                TupleColumn tc = (TupleColumn)this.columnCounters.get(folder.name());
                tc.value(numberOfRows, this.tupleValue);
                int end = this.tupleValue.getInt();
                int start = 0;
                if (numberOfRows > 0) {
                    tc.value(numberOfRows - 1, this.tupleValue);
                    start = this.tupleValue.getInt();
                }
                folder.setStartEndRow(start, end);
                folder.resetRows(folder.rows());
                tc.resetRows(1);
            }
        }
    }

    private Tuple getFolder(int index, int cursor) {
        Tuple tup = (Tuple)((TupleColumn)this.tupleColumns.get(index)).getDefaultValue().getObject();
        TupleColumn tc = (TupleColumn)this.columnCounters.get(tup.name());
        if (cursor > -1 && cursor < this.filledRows) {
            tc.value(cursor, this.tupleValue);
            int end = this.tupleValue.getInt();
            int start = 0;
            if (cursor > 0) {
                tc.value(cursor - 1, this.tupleValue);
                start = this.tupleValue.getInt();
            }
            tup.setStartEndRow(start, end);
        } else if (cursor == this.filledRows && cursor > 0) {
            tc.value(cursor - 1, this.tupleValue);
            int start = this.tupleValue.getInt();
            tup.setStartEndRow(start, -1);
        }
        tup.newInternalCursor();
        return tup;
    }

    public IBaseTupleColumn column(int column) {
        return (IBaseTupleColumn)this.tupleColumns.get(column);
    }

    public IBaseTupleColumn column(String name) {
        return this.column(this.findColumn(name));
    }

    private TupleColumn tupleColumn(int column) {
        return (TupleColumn)this.column(column);
    }

    public static abstract class TupleColumnFactory {
        public static TupleColumn createTupleColumn(String name, Class type, Value value, Tuple tuple) {
            return TupleColumnFactory.createTupleColumn(name, type, value, "", tuple);
        }

        public static TupleColumn createTupleColumn(String name, Class type, Value value, String options, Tuple tuple) {
            if (type == Integer.TYPE) {
                return new TupleColumn.TupleColumnInt(name, value, options, tuple);
            }
            if (type == Short.TYPE) {
                return new TupleColumn.TupleColumnShort(name, value, options, tuple);
            }
            if (type == Long.TYPE) {
                return new TupleColumn.TupleColumnLong(name, value, options, tuple);
            }
            if (type == Float.TYPE) {
                return new TupleColumn.TupleColumnFloat(name, value, options, tuple);
            }
            if (type == Double.TYPE) {
                return new TupleColumn.TupleColumnDouble(name, value, options, tuple);
            }
            if (type == Boolean.TYPE) {
                return new TupleColumn.TupleColumnBoolean(name, value, options, tuple);
            }
            if (type == Byte.TYPE) {
                return new TupleColumn.TupleColumnByte(name, value, options, tuple);
            }
            if (type == Character.TYPE) {
                return new TupleColumn.TupleColumnChar(name, value, options, tuple);
            }
            if (type == (class$java$lang$String == null ? (class$java$lang$String = Tuple.class$("java.lang.String")) : class$java$lang$String)) {
                return new TupleColumn.TupleColumnString(name, value, options, tuple);
            }
            if (type == (class$hep$aida$ITuple == null ? (class$hep$aida$ITuple = Tuple.class$("hep.aida.ITuple")) : class$hep$aida$ITuple)) {
                return new TupleColumn.TupleColumnFolder(name, tuple, options);
            }
            return new TupleColumn.TupleColumnObject(name, type, value, options, tuple);
        }
    }
}

