/*
 * Decompiled with CFR 0.152.
 */
package hep.io.hbook;

import hep.io.hbook.Hbook;
import hep.io.hbook.HbookObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CompositeHbookObject
extends HbookObject {
    static final int FOLDER = 0;
    static final int CWTUPLE = 1;
    static final int RWTUPLE = 2;
    private int type;
    private Vector children;
    private final Hashtable indexesOfChildren = new Hashtable();

    CompositeHbookObject(String name) {
        super(name);
        this.type = 0;
    }

    CompositeHbookObject(CompositeHbookObject parent, String name, int type) {
        super(parent, name);
        this.type = type;
    }

    void addChild(String name, HbookObject child) {
        this.indexesOfChildren.put(name, new Integer(this.children.size()));
        this.children.addElement(child);
    }

    public final HbookObject getChild(int index) {
        if (this.children == null) {
            this.visitChildren();
        }
        return (HbookObject)this.children.elementAt(index);
    }

    public final HbookObject getChild(String name) {
        Object o;
        if (this.children == null) {
            this.visitChildren();
        }
        if ((o = this.indexesOfChildren.get(name)) != null) {
            return (HbookObject)this.children.elementAt((Integer)o);
        }
        return null;
    }

    void close() {
        if (this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                HbookObject h = (HbookObject)e.nextElement();
                h.close();
            }
        }
    }

    public Enumeration getChildren() {
        if (this.children == null) {
            this.visitChildren();
        }
        return this.children.elements();
    }

    public String toString() {
        if (this.children != null) {
            return "Folder: " + this.getName() + " (" + this.children.size() + " elements)";
        }
        return "Folder: " + this.getName();
    }

    public final int nChildren() {
        if (this.children == null) {
            this.visitChildren();
        }
        return this.children.size();
    }

    public final int getIndex(String name) {
        Integer index;
        if (this.children == null) {
            this.visitChildren();
        }
        if ((index = (Integer)this.indexesOfChildren.get(name)) == null) {
            return -1;
        }
        return index;
    }

    private void visitChildren() {
        this.children = new Vector();
        Hbook.visitChildren(this);
    }
}

