/*
 * Decompiled with CFR 0.152.
 */
package hep.io.stdhep;

import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOWriter;
import hep.io.stdhep.StdhepConstants;
import hep.io.stdhep.StdhepEvent;
import hep.io.stdhep.StdhepReader;
import hep.io.stdhep.StdhepRecord;
import java.io.IOException;

public class StdhepWriter
extends MCFIOWriter
implements StdhepConstants {
    private static int[] blockIds = new int[]{101, 105, 106, 107};
    private static String[] blockNames = new String[]{"Stdhep Event", "Stdhep Multi", "Stdhep Begin Run", "Stdhep End Run"};
    private MCFIOEventWrapper event = new MCFIOEventWrapper();

    public StdhepWriter(String file, String title, String comment, int numevts) throws IOException {
        super(file, title, comment, numevts, blockIds, blockNames);
    }

    public static void main(String[] argv) throws Exception {
        StdhepReader r = new StdhepReader("c:\\temp\\pybms-ZZ-500-990115-gen-98.dat");
        StdhepWriter w = new StdhepWriter("test.stdhep", r.getTitle(), r.getComment(), r.getNumberOfEvents());
        try {
            while (true) {
                StdhepRecord record = r.nextRecord();
                System.out.println("record=" + record);
                w.writeRecord(record);
            }
        }
        catch (Throwable throwable) {
            w.close();
            r.close();
            throw throwable;
        }
    }

    public void writeRecord(StdhepRecord record) throws IOException {
        if (compatibilityMode && record instanceof StdhepEvent && ((StdhepEvent)record).getNHEP() > 4000) {
            throw new IOException("Too many particles");
        }
        this.event.setRecord(record);
        this.write(this.event);
    }

    private class MCFIOEventWrapper
    implements MCFIOEvent {
        private StdhepRecord record;

        private MCFIOEventWrapper() {
        }

        public MCFIOBlock getBlock(int index) {
            return this.record;
        }

        public int getBlockID(int index) {
            return this.record.getID();
        }

        public int getEventNumber() {
            if (this.record instanceof StdhepEvent) {
                return ((StdhepEvent)this.record).getNEVHEP();
            }
            return 0;
        }

        public int getNBlocks() {
            return 1;
        }

        public int getRunNumber() {
            return 0;
        }

        public int getStoreNumber() {
            return 0;
        }

        public int getTrigMask() {
            return 0;
        }

        void setRecord(StdhepRecord record) throws IOException {
            this.record = record;
        }
    }
}

